/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.monitor.Channel;
import org.lsst.ccs.subsystem.monitor.Device;

public class CalcDevice
extends Device {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private final List<String> subtypeList = new ArrayList<String>();
    private final List<Integer> chanList = new ArrayList<Integer>();
    private int keyValue = 0;

    @Override
    protected void initialize() {
        this.initSensors();
        this.setOnline(true);
    }

    @Override
    protected void close() {
    }

    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            this.mon.reportError(name, "type", type);
        }
        this.subtypeList.add(this.keyValue, subtype);
        return new int[]{iType << 16 | this.keyValue++, 0};
    }

    @Override
    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        int key = type & 0xFFFF;
        String subtypeS = this.subtypeList.get(key);
        String[] names = subtypeS.split(":", -1);
        try {
            int id0 = 0;
            int id1 = 0;
            if (names.length != 2 || (id0 = this.mon.getChannelId(names[0])) < 0 || (id1 = this.mon.getChannelId(names[1])) < 0) {
                this.mon.reportError(name, "subtype", subtypeS);
            }
            this.chanList.add(key, id0 << 16 | id1);
        }
        catch (Exception e) {
            this.dropChannel(id);
        }
    }

    @Override
    protected double readChannel(int hwChan, int type) {
        int chans = this.chanList.get(type & 0xFFFF);
        Channel chan1 = this.mon.getChannel(chans >> 16);
        Channel chan2 = this.mon.getChannel(chans & 0xFFFF);
        double value = Double.NaN;
        if (chan1.getState() != -1 && chan2.getState() != -1) {
            switch (type >> 16) {
                case 4: {
                    value = chan1.getValue() + chan2.getValue();
                    break;
                }
                case 5: {
                    value = chan1.getValue() - chan2.getValue();
                    break;
                }
                case 6: {
                    value = chan1.getValue() * chan2.getValue();
                    break;
                }
                case 7: {
                    value = chan1.getValue() / chan2.getValue();
                }
            }
        }
        return value;
    }

    static {
        typeMap.put("SUM", 4);
        typeMap.put("DIFF", 5);
        typeMap.put("PROD", 6);
        typeMap.put("QUOT", 7);
    }
}

