/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.thermalsim;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalModel;

public abstract class ThermalSimElement {
    protected volatile long timeStep = 20L;
    protected volatile long lastVisit = 0L;
    protected volatile ScheduledFuture<?> future = null;
    ThermalModel model;
    String name;

    public ThermalSimElement(ThermalModel model, String name) {
        this.model = model;
        this.name = name;
        model.addElement(this);
    }

    public void setTimeStep(long timeStep) {
        this.timeStep = timeStep;
        if (this.future != null) {
            this.future.cancel(false);
            this.start();
        }
    }

    public String getName() {
        return this.name;
    }

    void start() {
        long ts = this.timeStep / (long)this.model.speedUp;
        if (ts < 1L) {
            ts = 1L;
        }
        this.future = this.model.execService.scheduleAtFixedRate(() -> this.doThermalLoop(), 0L, ts, TimeUnit.MILLISECONDS);
    }

    void stop() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    public long getTimeStep() {
        return this.timeStep;
    }

    private void doThermalLoop() {
        long t = System.currentTimeMillis();
        long dt = this.lastVisit == 0L ? 0L : t - this.lastVisit;
        this.lastVisit = t;
        this.thermalLoop(dt *= (long)this.model.speedUp);
    }

    protected ThermalSimElement getActualRight() {
        return this;
    }

    protected ThermalSimElement getActualLeft() {
        return this;
    }

    protected abstract void thermalLoop(long var1);

    public void dump() {
        if (this.getTemperature() > 0.0) {
            System.out.printf("%-15s %-30s %5.2f %40s\n", this.name, this.getClass().getSimpleName(), this.getTemperature(), this.getExtraInfo());
        } else {
            System.out.printf("%-15s %-30s       %40s\n", this.name, this.getClass().getSimpleName(), this.getExtraInfo());
        }
    }

    protected String getExtraInfo() {
        return "";
    }

    public boolean isActive() {
        return true;
    }

    public double getTemperature() {
        return 0.0;
    }
}

