/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.thermalsim;

import org.lsst.ccs.subsystem.common.thermalsim.ThermalCapacitance;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalModel;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalSimElement;

public abstract class ThermalLink
extends ThermalSimElement {
    protected ThermalCapacitance left;
    protected ThermalCapacitance right;

    public ThermalLink(ThermalModel model, String name) {
        super(model, name);
    }

    void setLeft(ThermalCapacitance left) {
        this.left = (ThermalCapacitance)left.getActualRight();
    }

    void setRight(ThermalCapacitance right) {
        this.right = (ThermalCapacitance)right.getActualLeft();
    }

    public ThermalCapacitance getLeft() {
        return this.left;
    }

    public ThermalCapacitance getRight() {
        return this.right;
    }

    public abstract double power(double var1, double var3);

    @Override
    protected void thermalLoop(long dt) {
        if (this.left == null || this.right == null) {
            return;
        }
        double qTransferred = this.power(this.left.getTemperature(), this.right.getTemperature()) * (double)dt / 1000.0;
        this.left.heat(-qTransferred);
        this.right.heat(qTransferred);
    }

    @Override
    protected String getExtraInfo() {
        return String.format("%10s< >%-10s", this.getLeft() == null ? "\u00d8" : this.getLeft().getName(), this.getRight() == null ? "\u00d8" : this.getRight().getName());
    }
}

