/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.thermalsim;

import org.lsst.ccs.subsystem.common.thermalsim.ThermalModel;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalSimElement;
import org.python.google.common.util.concurrent.AtomicDouble;

public class ThermalCapacitance
extends ThermalSimElement {
    protected AtomicDouble temperature = new AtomicDouble();
    protected AtomicDouble qAccumulated = new AtomicDouble();
    double thermalCap;

    public ThermalCapacitance(ThermalModel model, String name, double capacitance) {
        super(model, name);
        this.thermalCap = capacitance;
    }

    @Override
    public double getTemperature() {
        return this.temperature.get();
    }

    public void setTemperature(double t) {
        this.temperature.set(t);
    }

    public double increaseTemperature(double dt) {
        return this.temperature.addAndGet(dt);
    }

    public synchronized void heat(double q) {
        this.qAccumulated.addAndGet(q);
    }

    @Override
    protected void thermalLoop(long dt) {
        double q = this.qAccumulated.get();
        this.qAccumulated.addAndGet(-q);
        double deltaT = q / this.thermalCap;
        if (deltaT > 50.0) {
            deltaT = 50.0;
        }
        if (deltaT < -50.0) {
            deltaT = -50.0;
        }
        this.increaseTemperature(deltaT);
    }

    @Override
    protected String getExtraInfo() {
        return String.format(" c=%5.2f", this.thermalCap);
    }
}

