/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.thermalsim;

import org.lsst.ccs.subsystem.common.thermalcontrol.PIDController;
import org.lsst.ccs.subsystem.common.thermalsim.HeatSink;
import org.lsst.ccs.subsystem.common.thermalsim.HeatSource;
import org.lsst.ccs.subsystem.common.thermalsim.LumpedThermalCapacitanceLink;
import org.lsst.ccs.subsystem.common.thermalsim.ResistiveThermalLink;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalCapacitance;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalCapacitanceLink;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalModel;

public class TestModel {
    public static PIDController pidController;

    public static void main(String[] args) throws Exception {
        ThermalModel model = new ThermalModel();
        TestModel.testModelPID(model);
        model.dump();
        System.out.println("---------");
        System.out.println("---------");
        model.dumpActive();
        System.out.println("---------");
        System.out.println("---------");
        model.start();
        if (pidController != null) {
            pidController.start();
        }
        int i = 0;
        while (true) {
            model.dumpActive();
            System.out.println("--------- " + model.speedUp);
            if (++i % 20 == 0) {
                model.dump();
                System.out.println("---------");
                System.out.println("---------");
            }
            Thread.sleep(2000L);
            if (i != 20) continue;
            System.out.println("---------NORMAL SPEED-------");
            model.setSpeedUp(1);
        }
    }

    public static void testModel1(ThermalModel model) throws Exception {
        HeatSink sink = new HeatSink(model, "sink", 273.0);
        ResistiveThermalLink l1 = new ResistiveThermalLink(model, "l1", 1.995);
        ThermalCapacitance b1 = new ThermalCapacitance(model, "b1", 10.0);
        b1.setTemperature(200.0);
        HeatSource fridge = new HeatSource(model, "refrig", -50.0);
        ResistiveThermalLink l2 = new ResistiveThermalLink(model, "l2", 0.495);
        ThermalCapacitance end = new ThermalCapacitance(model, "end", 5.0);
        end.setTemperature(200.0);
        HeatSource power = new HeatSource(model, "power", 5.0);
        model.connect(sink, l1);
        model.connect(l1, b1);
        model.connect(b1, l2);
        model.connect(l2, end);
        fridge.attachTo(b1);
        power.attachTo(end);
    }

    public static void testModel2(ThermalModel model) throws Exception {
        HeatSink sink = new HeatSink(model, "sink", 273.0);
        ResistiveThermalLink l1 = new ResistiveThermalLink(model, "l1", 1.995);
        ThermalCapacitanceLink b1 = new ThermalCapacitanceLink(model, "b1", 0.01, 10.0);
        b1.setTemperature(200.0);
        HeatSource fridge = new HeatSource(model, "refrig", -50.0);
        ResistiveThermalLink l2 = new ResistiveThermalLink(model, "l2", 0.495);
        ThermalCapacitance end = new ThermalCapacitance(model, "end", 5.0);
        end.setTemperature(200.0);
        HeatSource power = new HeatSource(model, "power", 5.0);
        model.connect(sink, l1);
        model.connect(l1, b1);
        model.connect(b1, l2);
        model.connect(l2, end);
        fridge.attachTo(b1.cap);
        power.attachTo(end);
    }

    public static void testModel3(ThermalModel model) throws Exception {
        HeatSink sink = new HeatSink(model, "sink", 273.0);
        ResistiveThermalLink l1 = new ResistiveThermalLink(model, "l1", 1.995);
        ThermalCapacitance b1 = new ThermalCapacitance(model, "b1", 10.0);
        b1.setTemperature(200.0);
        HeatSource fridge = new HeatSource(model, "refrig", -50.0);
        ResistiveThermalLink l2 = new ResistiveThermalLink(model, "l2", 0.125);
        LumpedThermalCapacitanceLink b2 = new LumpedThermalCapacitanceLink(model, "b2", 0.25, 20.0, 8);
        b2.setTemperature(200.0);
        ResistiveThermalLink l3 = new ResistiveThermalLink(model, "l3", 0.12);
        ThermalCapacitance end = new ThermalCapacitance(model, "end", 5.0);
        end.setTemperature(200.0);
        HeatSource power = new HeatSource(model, "power", 5.0);
        model.connect(sink, l1);
        model.connect(l1, b1);
        model.connect(b1, l2);
        model.connect(l2, b2);
        model.connect(b2, l3);
        model.connect(l3, end);
        fridge.attachTo(b1);
        power.attachTo(end);
    }

    public static void testModelPID(ThermalModel model) throws Exception {
        HeatSink sink = new HeatSink(model, "sink", 273.0);
        ResistiveThermalLink l1 = new ResistiveThermalLink(model, "l1", 1.995);
        ThermalCapacitance b1 = new ThermalCapacitance(model, "b1", 10.0);
        b1.setTemperature(200.0);
        HeatSource fridge = new HeatSource(model, "refrig", -50.0);
        ResistiveThermalLink l2 = new ResistiveThermalLink(model, "l2", 0.495);
        ThermalCapacitance end = new ThermalCapacitance(model, "end", 5.0);
        end.setTemperature(200.0);
        HeatSource power = new HeatSource(model, "power", 5.0);
        HeatSource heater = new HeatSource(model, "heater", 5.0);
        model.connect(sink, l1);
        model.connect(l1, b1);
        model.connect(b1, l2);
        model.connect(l2, end);
        fridge.attachTo(b1);
        power.attachTo(end);
        heater.attachTo(end);
        PIDController pid = new PIDController(() -> end.getTemperature(), p -> heater.setPower(p));
        pid.setTarget(210.0);
        pidController = pid;
    }

    public static void rtmModel(ThermalModel model) throws Exception {
    }
}

