/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.thermalsim;

import org.lsst.ccs.subsystem.common.thermalsim.MergedResistiveThermalLink;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalCapacitance;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalLink;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalModel;

public class ResistiveThermalLink
extends ThermalLink {
    protected double res;
    MergedResistiveThermalLink mergedLink = null;

    public ResistiveThermalLink(ThermalModel model, String name, double resistance) {
        super(model, name);
        this.res = resistance;
    }

    public void setMergedLink(MergedResistiveThermalLink mergedLink) {
        this.mergedLink = mergedLink;
    }

    @Override
    void setRight(ThermalCapacitance right) {
        if (this.mergedLink != null) {
            this.mergedLink.setRight(right);
        } else {
            super.setRight(right);
        }
    }

    @Override
    void setLeft(ThermalCapacitance left) {
        if (this.mergedLink != null) {
            this.mergedLink.setLeft(left);
        } else {
            super.setLeft(left);
        }
    }

    @Override
    public double power(double tLeft, double tRight) {
        return (tLeft - tRight) / this.res;
    }

    @Override
    protected String getExtraInfo() {
        return String.format(" r=%5.2f", this.res);
    }

    @Override
    public boolean isActive() {
        return this.mergedLink == null;
    }
}

