/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.thermalsim;

import org.lsst.ccs.subsystem.common.thermalsim.ThermalCapacitance;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalLink;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalModel;

public class RadiativeThermalLink
extends ThermalLink {
    private final double sigma = 5.67E-8;
    private double area;
    private double emis1 = 0.06;
    private double emis2 = 0.06;

    public RadiativeThermalLink(ThermalModel model, String name, double area) {
        super(model, name);
        this.area = area;
    }

    @Override
    public double power(double t1, double t2) {
        return this.emis2 * this.emis2 / (this.emis1 + this.emis2 - this.emis1 * this.emis2) * 5.67E-8 * this.area * (Math.pow(t1, 4.0) - Math.pow(t2, 4.0));
    }

    public void setLeft(ThermalCapacitance e1, double emissivity) {
        super.setLeft(e1);
        this.emis1 = emissivity;
    }

    public void setRight(ThermalCapacitance e2, double emissivity) {
        super.setRight(e2);
        this.emis2 = emissivity;
    }

    public void setEmis1(double emis1) {
        this.emis1 = emis1;
    }

    public void setEmis2(double emis2) {
        this.emis2 = emis2;
    }

    @Override
    protected String getExtraInfo() {
        return String.format(" a=%5.2f", this.area);
    }
}

