/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.thermalsim;

import org.lsst.ccs.subsystem.common.thermalsim.ThermalCapacitance;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalModel;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalSimElement;

public class HeatSource
extends ThermalSimElement {
    volatile double power;
    protected ThermalCapacitance element;

    public HeatSource(ThermalModel model, String name, double power) {
        super(model, name);
        this.power = power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    public double getPower() {
        return this.power;
    }

    public void attachTo(ThermalCapacitance e) {
        this.element = e;
    }

    public ThermalCapacitance getAttached() {
        return this.element;
    }

    @Override
    protected void thermalLoop(long dt) {
        double qTransferred = this.power * (double)dt / 1000.0;
        this.element.heat(qTransferred);
    }

    @Override
    protected String getExtraInfo() {
        return String.format(" p=%5.2f", this.power);
    }
}

