package org.lsst.ccs.subsystem.common.thermalsim;


/**
 * A generic thermal link that transfers heat between elements.
 * 
 * @author aubourg
 *
 */
public abstract class ThermalLink extends ThermalSimElement {

    public ThermalLink(ThermalModel model, String name) {
        super(model, name);
    }

    protected ThermalCapacitance left, right;

    void setLeft(ThermalCapacitance left) {
        this.left = (ThermalCapacitance) left.getActualRight();
    }

    void setRight(ThermalCapacitance right) {
        this.right = (ThermalCapacitance) right.getActualLeft();
    }

    public ThermalCapacitance getLeft() {
        return left;
    }

    public ThermalCapacitance getRight() {
        return right;
    }

    // power transferred from t1 to t2
    public abstract double power(double tLeft, double tRight);

    @Override
    protected void thermalLoop(long dt) {

        if (left == null || right == null)
            return;
        double qTransferred = power(left.getTemperature(), right.getTemperature()) * dt / 1000.;
        left.heat(-qTransferred);
        right.heat(qTransferred);
        // System.out.printf("link %-10s Q %6.4f\n", name, qTransferred);
    }

    protected String getExtraInfo() {
        return String.format("%10s< >%-10s", getLeft() == null ? "Ø" : getLeft().getName(), getRight() == null ? "Ø" : getRight().getName());

        // return "<" + (getLeft() == null ? "Ø" : getLeft().getName()) + " >" +
        // (getRight() == null ? "Ø" : getRight().getName());
    }

}
