package org.lsst.ccs.subsystem.common.thermalsim;

import org.lsst.ccs.subsystem.common.thermalcontrol.PIDController;

public class TestModel {

    public static PIDController pidController;

    public static void main(String[] args) throws Exception {
        ThermalModel model = new ThermalModel();

        testModelPID(model);

        model.dump();
        System.out.println("---------");
        System.out.println("---------");
        model.dumpActive();
        System.out.println("---------");
        System.out.println("---------");

        // model.setSpeedUp(10);

        model.start();

        if (pidController != null)
            pidController.start();
        
       // ZieglerNicholsTuner tuner = new ZieglerNicholsTuner(pidController);
       // tuner.tune();


        int i = 0;
        while (true) {
            model.dumpActive();
            System.out.println("--------- " + model.speedUp);
            i++;
            if (i % 20 == 0) {
                model.dump();
                System.out.println("---------");
                System.out.println("---------");
            }
            Thread.sleep(2000);
            if (i == 20) {
                System.out.println("---------NORMAL SPEED-------");
                model.setSpeedUp(1);
                
            }
        }
    }

    public static void testModel1(ThermalModel model) throws Exception {
        HeatSink sink = new HeatSink(model, "sink", 273);
        ResistiveThermalLink l1 = new ResistiveThermalLink(model, "l1", 2 - 0.005);
        ThermalCapacitance b1 = new ThermalCapacitance(model, "b1", 10);
        b1.setTemperature(200);
        HeatSource fridge = new HeatSource(model, "refrig", -50);
        ResistiveThermalLink l2 = new ResistiveThermalLink(model, "l2", 0.5 - 0.005);
        ThermalCapacitance end = new ThermalCapacitance(model, "end", 5);
        end.setTemperature(200);
        HeatSource power = new HeatSource(model, "power", 5);

        model.connect(sink, l1);
        model.connect(l1, b1);
        model.connect(b1, l2);
        model.connect(l2, end);

        fridge.attachTo(b1);
        power.attachTo(end);
    }

    public static void testModel2(ThermalModel model) throws Exception {
        HeatSink sink = new HeatSink(model, "sink", 273);
        ResistiveThermalLink l1 = new ResistiveThermalLink(model, "l1", 2 - 0.005);
        ThermalCapacitanceLink b1 = new ThermalCapacitanceLink(model, "b1", 0.01, 10);
        // ThermalCapacitance b1 = new ThermalCapacitance(model, "b1", 10);
        b1.setTemperature(200);
        HeatSource fridge = new HeatSource(model, "refrig", -50);
        ResistiveThermalLink l2 = new ResistiveThermalLink(model, "l2", 0.5 - 0.005);
        ThermalCapacitance end = new ThermalCapacitance(model, "end", 5);
        end.setTemperature(200);
        HeatSource power = new HeatSource(model, "power", 5);

        model.connect(sink, l1);
        model.connect(l1, b1);
        model.connect(b1, l2);
        model.connect(l2, end);

        fridge.attachTo(b1.cap);
        power.attachTo(end);
    }

    public static void testModel3(ThermalModel model) throws Exception {
        HeatSink sink = new HeatSink(model, "sink", 273);
        ResistiveThermalLink l1 = new ResistiveThermalLink(model, "l1", 2 - 0.005);
        ThermalCapacitance b1 = new ThermalCapacitance(model, "b1", 10);
        b1.setTemperature(200);
        HeatSource fridge = new HeatSource(model, "refrig", -50);
        ResistiveThermalLink l2 = new ResistiveThermalLink(model, "l2", 0.125);
        LumpedThermalCapacitanceLink b2 = new LumpedThermalCapacitanceLink(model, "b2", 0.25, 20, 8);
        b2.setTemperature(200);
        ResistiveThermalLink l3 = new ResistiveThermalLink(model, "l3", 0.125 - 0.005);
        ThermalCapacitance end = new ThermalCapacitance(model, "end", 5);
        end.setTemperature(200);
        HeatSource power = new HeatSource(model, "power", 5);

        model.connect(sink, l1);
        model.connect(l1, b1);
        model.connect(b1, l2);
        model.connect(l2, b2);
        model.connect(b2, l3);
        model.connect(l3, end);

        fridge.attachTo(b1);
        power.attachTo(end);
    }

    public static void testModelPID(ThermalModel model) throws Exception {
        HeatSink sink = new HeatSink(model, "sink", 273);
        ResistiveThermalLink l1 = new ResistiveThermalLink(model, "l1", 2 - 0.005);
        ThermalCapacitance b1 = new ThermalCapacitance(model, "b1", 10);
        b1.setTemperature(200);
        HeatSource fridge = new HeatSource(model, "refrig", -50);
        ResistiveThermalLink l2 = new ResistiveThermalLink(model, "l2", 0.5 - 0.005);
        ThermalCapacitance end = new ThermalCapacitance(model, "end", 5);
        end.setTemperature(200);
        HeatSource power = new HeatSource(model, "power", 5);
        HeatSource heater = new HeatSource(model, "heater", 5);

        model.connect(sink, l1);
        model.connect(l1, b1);
        model.connect(b1, l2);
        model.connect(l2, end);

        fridge.attachTo(b1);
        power.attachTo(end);
        heater.attachTo(end);

        PIDController pid = new PIDController(() -> end.getTemperature(), (p) -> heater.setPower(p));
        pid.setTarget(210);

        pidController = pid;
    }

    public static void rtmModel(ThermalModel model) throws Exception {

    }

}
