package org.lsst.ccs.subsystem.common.thermalsim;

/**
 * A resistive thermal link. Resistance is given in K/W.
 * 
 * @author aubourg
 *
 */
public class ResistiveThermalLink extends ThermalLink {

    public ResistiveThermalLink(ThermalModel model, String name, double resistance) {
        super(model, name);
        this.res = resistance;
    }

    protected double res; // K/W

    MergedResistiveThermalLink mergedLink = null;

    public void setMergedLink(MergedResistiveThermalLink mergedLink) {
        this.mergedLink = mergedLink;
    }

    @Override
    void setRight(ThermalCapacitance right) {
        if (mergedLink != null)
            mergedLink.setRight(right);
        else
            super.setRight(right);
    }

    @Override
    void setLeft(ThermalCapacitance left) {
        if (mergedLink != null)
            mergedLink.setLeft(left);
        else
            super.setLeft(left);
    }

    @Override
    public double power(double tLeft, double tRight) {
        // System.out.printf("link %-10s dT %6.4f\n", tLeft - tRight);

        return (tLeft - tRight) / res;
    }

    @Override
    protected String getExtraInfo() {
        return String.format(" r=%5.2f", res);
    }

    public boolean isActive() {
        return mergedLink == null;
    }

}
