package org.lsst.ccs.subsystem.common.thermalsim;

/**
 * A heat source that provides power (in W) to an attached capacitance.
 * 
 * Power can be adjusted in real time through setPower.
 * 
 * @author aubourg
 *
 */
public class HeatSource extends ThermalSimElement {

    public HeatSource(ThermalModel model, String name, double power) {
        super(model, name);
        this.power = power;
    }

    volatile double power;
    protected ThermalCapacitance element;

    public void setPower(double power) {
        this.power = power;
    }

    public double getPower() {
        return power;
    }

    public void attachTo(ThermalCapacitance e) {
        this.element = e;
    }

    public ThermalCapacitance getAttached() {
        return element;
    }

    @Override
    protected void thermalLoop(long dt) {
        double qTransferred = power * dt / 1000.;
        element.heat(qTransferred);
        // System.out.printf("src %-10s Q %6.4f\n", name, qTransferred);
    }

    @Override
    protected String getExtraInfo() {
        return String.format(" p=%5.2f", power);
    }

}
