package org.lsst.ccs.subsystem.common.thermalsim;

/**
 * Heat sink with fixed temperature.
 * 
 * @author aubourg
 *
 */
public class HeatSink extends ThermalCapacitance {

    public HeatSink(ThermalModel model, String name, double temperature) {
        super(model, name, 0);
        this.temperature.set(temperature);
    }

    @Override
    public double increaseTemperature(double dt) {
        // noop
        return getTemperature();
    }

    @Override
    protected void thermalLoop(long dt) {
        // passive element. Noop.
    }

}
