package org.lsst.ccs.subsystem.common;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.utilities.logging.Logger;

public class SignalGenerator extends Module {

        private static final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.signalgenerator");
    /**
	 * 
	 */
    private static final long serialVersionUID = -7468331402973978441L;

    static long timeOrigin = System.currentTimeMillis();

    public static long getTimeOrigin() {
        return timeOrigin;
    }

    enum SignalType {
        SINE, SQUARE, TRIANGLE
    }

    SignalType signalType = SignalType.SINE;

    double frequency = 10; // Hz
    double phase = 0; // compared to system millis - tOrigin, in radians
    double amplitude = 1;
    double dc = 0;
    String output = "signal";

    public SignalGenerator() {
        super(1000);
        log.info("signal generator constructed "+getTickMillis());
    }

    public void setSignalType(String type) {
        signalType = SignalType.valueOf(type);
    }

    public String getSignalType() {
        return signalType.toString();
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public double getFrequency() {
        return frequency;
    }

    public void setPhase(double phase) {
        this.phase = phase;
    }

    public double getPhase() {
        return phase;
    }

    public void setAmplitude(double amplitude) {
        this.amplitude = amplitude;
    }

    public double getAmplitude() {
        return amplitude;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getOutput() {
        return output;
    }

    public double getDc() {
        return dc;
    }

    public void setDc(double dc) {
        this.dc = dc;
    }

    long lastTick = 0;

    @Override
    public void tick() {
        try {
            long ts = System.currentTimeMillis();
            if (ts - lastTick <= tickMillis / 5)
                return;
            lastTick = ts;
            double t = (ts - timeOrigin) / 1000.;
            double phi = (2 * Math.PI * t * frequency + phase) % (2 * Math.PI);

            double x = 0;
            switch (signalType) {
            case SINE:
                x = amplitude * Math.sin(phi);
                break;
            case SQUARE:
                x = (phi > Math.PI) ? -amplitude : amplitude;
                break;
            case TRIANGLE:
                x = (phi > Math.PI) ? amplitude * (3 - 2 * phi / Math.PI)
                        : amplitude * (2 * phi / Math.PI - 1);
                break;
            }

            x += dc;
            
            log.info("new signal "+x);

            setChanged();
            notifyObservers(new ValueUpdate(output, x, ts));
        } catch (Exception e) {
            log.error(e);
        }
    }

}
