package org.lsst.ccs.subsystem.common;

import java.util.ArrayList;
import java.util.HashMap;

import org.apache.commons.beanutils.MethodUtils;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.utilities.logging.Logger;

// TODO in progress

/**
 * A generic sequencer module.
 * 
 * This sequencer module can call methods, set values, sleep for some delay,
 * wait for some state change or update value broadcast, loop...
 * 
 * It can accept commands and act as a facade of a whole ModularSubsystem.
 * 
 * TODO this should use Groovy DSL 
 * 
 * 
 * @author aubourg
 * 
 */

// TODO wait for status
// TODO send command to other subsystem

public class Sequencer extends Module {

        private static final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.sequencer");
	/**
	 * 
	 */
	private static final long serialVersionUID = 2620624966948422368L;

	/**
	 * A Step in the programmation of this module
	 * 
	 * @author aubourg
	 * 
	 */
	public static abstract class Step {
		public abstract void init(String[] args);

		public int execute(Sequencer s, int pc) {
			return pc + 1;
		}
	}

	public static class Goto extends Step {
		@Override
		public void init(String[] args) {
			destLabel = args[1];
		}

		@Override
		public int execute(Sequencer s, int pc) {
			return s.findLabel(destLabel);
		};

		String destLabel;
	}

	public static class Label extends Step {
		@Override
		public void init(String[] args) {
			name = args[1];
		}

		String name;
		// internal branch destination.
		// should we have a different label for external (command bus)
		// invokation?
		// should we have a different command, or should we use the
		// MethodInvoker one?
		// should a special label be executed at startup
	}

	public static class CallMethod extends Step {
		@Override
		public void init(String[] args) {
			destination = args[1];
			method = args[2];
			// args?
		}

		@Override
		public int execute(Sequencer s, int pc) {
			Module m = (Module)s.getComponentByName(destination);
			try {
				MethodUtils.invokeMethod(m, method, null);
			} catch (Exception e) {
				throw new RuntimeException("cannot call method ", e);
			}
			return super.execute(s, pc);
		}

		String destination;
		String method;
		// Object[] args ?
	}

	public static class SleepMillis extends Step {
		@Override
		public void init(String[] args) {
			millis = Long.parseLong(args[1]);
		}

		@Override
		public int execute(Sequencer s, int pc) {
			try {
				Thread.sleep(millis);
			} catch (InterruptedException e) {
				log.warn("interrupted wait " + e);
			}
			return super.execute(s, pc);
		}

		long millis;
	}

	public static class Stop extends Step {
		@Override
		public void init(String[] args) {
		    // nothing to do
		}

		@Override
		public int execute(Sequencer s, int pc) {
			return -1;
		}
	}

	public static class WaitForUpdate extends Step {
		String property;

		// + condition met by broadcast value

		@Override
		public void init(String[] args) {
			throw new IllegalAccessError("not implemented");
		}
	}

	public static class WaitForProperty extends Step {
		String targetModule;
		String property;
		long millis = 20; // how often to check the value

		// + condition met by property value;
		@Override
		public void init(String[] args) {
			throw new IllegalAccessError("not implemented");

		}
	}

	ArrayList<Step> steps = new ArrayList<Step>();

	ArrayList<String> sequence = new ArrayList<String>();

	HashMap<String, Label> labels = new HashMap<String, Label>();

	public ArrayList<String> getSequence() {
		return sequence;
	}

	public void setSequence(ArrayList<String> sequence) {
		this.sequence = sequence;
	}

	protected void parseSequence() {
		System.out.println(Label.class.getName());
		for (String s : sequence) {
			String[] ss = s.split(" +");
			String cls = ss[0].substring(0, 1).toUpperCase()
					+ ss[0].substring(1);
			try {
				@SuppressWarnings("unchecked")
                Class<Step> stepClass = (Class<Step>) Class
						.forName(Sequencer.class.getName() + "$" + cls);
				Step instance = stepClass.newInstance();
				instance.init(ss);
				steps.add(instance);
				if (instance instanceof Label) {
					labels.put(ss[1], (Label) instance);
				}
			} catch (ClassNotFoundException e) {
				log.error("cannot interpret step " + s + " class not found");
				throw new RuntimeException(e);
			} catch (InstantiationException e) {
				throw new RuntimeException(e);
			} catch (IllegalAccessException e) {
				throw new RuntimeException(e);
			}
		}
	}

	@Override
	public void initModule() {
		parseSequence();
	}

	enum State {
		HALTED, RUNNING
	};

	State state = State.HALTED;
	int pc = 0;

	@Override
	public void start() {
		super.start();
		if (labels.containsKey("startup")) {
			execute("startup");
		}
	}

	public int findLabel(String label) {
		Label l = labels.get(label);
		return steps.indexOf(l);
	}

	public void execute(String label) {
		synchronized (this) {
			if (state == State.RUNNING)
				throw new RuntimeException(
						"Sequencer cannot execute if already running");
			state = State.RUNNING;
		}

		pc = findLabel(label);
		while (true) {
			pc = steps.get(pc).execute(this, pc);
			if (pc < 0)
				break;
		}

		synchronized (this) {
			state = State.HALTED;
		}

	}

}
