package org.lsst.ccs.subsystem.common;

import org.apache.commons.beanutils.BeanUtils;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.utilities.logging.Logger;

//  samples an attribute of another module and sends updates
// TODO could sample multiple attributes

public class SamplingMonitor extends Module {

        private static final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.samplingmonitor");
	/**
	 * 
	 */
	private static final long serialVersionUID = 3922168308498689239L;
	Module source;
	String attribute;
	String outAttribute;

	public Module getSource() {
		return source;
	}

	public void setSource(Module source) {
		this.source = source;
	}

	public String getAttribute() {
		return attribute;
	}

	public void setAttribute(String attribute) {
		this.attribute = attribute;
		if (outAttribute == null) {
			outAttribute = attribute;
		}
	}

	public String getOutAttribute() {
		return outAttribute;
	}

	public void setOutAttribute(String outAttribute) {
		this.outAttribute = outAttribute;
	}

	@Override
	public void tick() {
		try {
			String value = BeanUtils.getProperty(source, attribute);
			double x = Double.valueOf(value);
			setChanged();
			notifyObservers(new ValueUpdate(outAttribute, x));
		} catch (Exception e) {
			log.error(e);
		}
	}
}
