/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.util.Observable;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.utilities.logging.Logger;

public class ThresholdMonitor
extends Module {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.thresholdmonitor");
    private static final long serialVersionUID = -8306607108474223745L;
    String input;
    double lowLimit = -1.7976931348623157E308;
    double highLimit = Double.MAX_VALUE;
    double lowLimitClear = -1.7976931348623157E308;
    double highLimitClear = Double.MAX_VALUE;
    State state = State.OK;

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public double getLowLimit() {
        return this.lowLimit;
    }

    public void setLowLimit(double lowLimit) {
        this.lowLimit = lowLimit;
    }

    public double getHighLimit() {
        return this.highLimit;
    }

    public void setHighLimit(double highLimit) {
        this.highLimit = highLimit;
    }

    public double getLowLimitClear() {
        return this.lowLimitClear;
    }

    public void setLowLimitClear(double lowLimitClear) {
        this.lowLimitClear = lowLimitClear;
    }

    public double getHighLimitClear() {
        return this.highLimitClear;
    }

    public void setHighLimitClear(double highLimitClear) {
        this.highLimitClear = highLimitClear;
    }

    public State getState() {
        return this.state;
    }

    public void processUpdate(Observable source, Module.ValueUpdate update) {
        if (update.getName().equals(this.input)) {
            double x = (Double)update.getValue();
            switch (this.state) {
                case OK: {
                    if (x > this.highLimit) {
                        this.state = State.HIGH_ALARM;
                        this.setAlarm(this.state.name());
                        break;
                    }
                    if (!(x < this.lowLimit)) break;
                    this.state = State.LOW_ALARM;
                    this.setAlarm(this.state.name());
                    break;
                }
                case HIGH_ALARM: {
                    if (x < this.lowLimit) {
                        this.state = State.LOW_ALARM;
                        this.setAlarm(this.state.name());
                        break;
                    }
                    if (!(x < this.highLimitClear)) break;
                    this.state = State.OK;
                    this.clearAlarm();
                    break;
                }
                case LOW_ALARM: {
                    if (x > this.highLimit) {
                        this.state = State.HIGH_ALARM;
                        this.setAlarm(this.state.name());
                        break;
                    }
                    if (!(x > this.lowLimitClear)) break;
                    this.state = State.OK;
                    this.clearAlarm();
                }
            }
        }
    }

    protected void setAlarm(String cause) {
        String message = "Alarm " + (Object)((Object)this.state) + " on " + this.input;
        log.error((Object)message);
        this.getSubsystem().raiseAlert(new Alert("thresholdAlert001", message), AlertState.ALARM, "threshold alert " + cause);
    }

    protected void clearAlarm() {
        String message = "Alarm cleared on " + this.input;
        log.info((Object)message);
        this.getSubsystem().clearAllAlerts();
    }

    static enum State {
        OK,
        LOW_ALARM,
        HIGH_ALARM;

    }
}

