/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class Channel
extends ConfigurableComponent {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_TEMP = 0;
    public static final int TYPE_VOLTS = 1;
    public static final int TYPE_POWER = 2;
    public static final int TYPE_SWITCH = 3;
    public static final int TYPE_SUM = 4;
    public static final int TYPE_DIFF = 5;
    public static final int TYPE_PROD = 6;
    public static final int TYPE_QUOT = 7;
    public static final int STATE_OFFLINE = -1;
    public static final int STATE_GOOD = 0;
    public static final int STATE_WARNING = 1;
    public static final int STATE_ERROR = 2;
    private static final int LIMIT_CHECK_NONE = 0;
    private static final int LIMIT_CHECK_FLAG = 1;
    private static final int LIMIT_CHECK_ALARM = 2;
    private final String DEFAULT_FORMAT = "%.2f ";
    private static final Map<String, Integer> checkMap = new HashMap<String, Integer>();
    private String description = "";
    private String units = "";
    private String devcName;
    private int hwChan = 0;
    private String type = "";
    private String subtype = "";
    private double offset = 0.0;
    private double scale = 1.0;
    private String checkLo = "FLAG";
    private String alarmLo;
    private double dbandLo = 0.0;
    private String checkHi = "FLAG";
    private String alarmHi;
    private double dbandHi = 0.0;
    private String format = "%.2f ";
    @ConfigurationParameter(name="limitLo", category="Limits")
    private double limitLo = 0.0;
    @ConfigurationParameter(name="limitHi", category="Limits")
    private double limitHi = 0.0;
    private String name;
    private Device devc;
    private int typeI;
    private int subtypeI;
    private int checkLoI;
    private Alarm alarmLoA;
    private int checkHiI;
    private Alarm alarmHiA;
    private int id;
    private boolean valid;
    private Monitor mon;
    private double value;
    private long timestamp;
    private int state = -1;
    private double resetLo = 0.0;
    private double resetHi = 0.0;
    private boolean ignrAlarmLo;
    private boolean ignrAlarmHi;

    @Deprecated
    public Channel(String desc, String fmt, String unit, String devName, int chan, String type, String subtype, double offs, double scal, String checkLo, double limLo, double deadbandLo, String alarmLo, String checkHi, double limHi, double deadbandHi, String alarmHi) {
        this.description = desc;
        this.setFormat(fmt);
        this.units = unit;
        this.setDevcName(devName);
        this.hwChan = chan;
        this.type = type;
        this.subtype = subtype;
        this.offset = offs;
        this.scale = scal;
        this.checkLo = checkLo;
        this.limitLo = limLo;
        this.dbandLo = deadbandLo;
        this.alarmLo = alarmLo;
        this.checkHi = checkHi;
        this.limitHi = limHi;
        this.dbandHi = deadbandHi;
        this.alarmHi = alarmHi;
    }

    public Channel() {
    }

    @Deprecated
    public Channel(String desc, String unit, String devName, int chan, String type, String subtype, double offs, double scal, String checkLo, double limLo, double deadbandLo, String alarmLo, String checkHi, double limHi, double deadbandHi, String alarmHi) {
        this(desc, null, unit, devName, chan, type, subtype, offs, scal, checkLo, limLo, deadbandLo, alarmLo, checkHi, limHi, deadbandHi, alarmHi);
    }

    public final void setFormat(String fmt) {
        this.format = fmt == null || fmt.isEmpty() ? "%.2f " : (fmt.charAt(0) != '%' ? "%" + fmt : fmt) + " ";
    }

    public final void setDevcName(String devName) {
        this.devcName = devName == null ? "Calc" : devName;
    }

    @ConfigurationParameterChanger
    public void setLimitLo(double limit) {
        if (limit == this.limitLo) {
            return;
        }
        this.limitLo = limit;
        this.setResetLo();
        if (this.valid) {
            this.mon.loLimChange.set(this.id);
            KeyValueDataList data = new KeyValueDataList(this.name);
            data.addData("alarmLow", (Serializable)((Object)String.valueOf(limit)), KeyValueData.KeyValueDataType.KeyValueMetaData);
            this.mon.subsys.publishSubsystemDataOnStatusBus((KeyValueData)data);
            this.mon.publishState();
        }
    }

    @ConfigurationParameterChanger
    public void setLimitHi(double limit) {
        if (limit == this.limitHi) {
            return;
        }
        this.limitHi = limit;
        this.setResetHi();
        if (this.valid) {
            this.mon.hiLimChange.set(this.id);
            KeyValueDataList data = new KeyValueDataList(this.name);
            data.addData("alarmHigh", (Serializable)((Object)String.valueOf(limit)), KeyValueData.KeyValueDataType.KeyValueMetaData);
            this.mon.subsys.publishSubsystemDataOnStatusBus((KeyValueData)data);
            this.mon.publishState();
        }
    }

    public void setDbandLo(double value) {
        this.dbandLo = value;
        this.setResetLo();
    }

    public void setDbandHi(double value) {
        this.dbandHi = value;
        this.setResetHi();
    }

    private void setResetLo() {
        this.resetLo = this.dbandLo <= 0.0 ? this.limitLo : this.limitLo + this.dbandLo;
    }

    private void setResetHi() {
        this.resetHi = this.dbandHi <= 0.0 ? this.limitHi : this.limitHi - this.dbandHi;
    }

    void configure(Monitor mon, int id) {
        this.name = this.getName();
        this.mon = mon;
        this.id = id;
        this.checkLoI = 1;
        this.checkHiI = 1;
        this.typeI = -1;
        this.subtypeI = -1;
        try {
            if (this.devcName == null) {
                mon.reportError(this.name, "device name");
            }
            this.devc = mon.getDevice(this.devcName);
            if (this.devc == null) {
                mon.reportError(this.name, "device name", this.devcName);
            }
            String origFmt = this.format;
            try {
                String string = String.format(this.format, 0.0);
            }
            catch (IllegalFormatException e) {
                this.format = "%.2f ";
                mon.reportError(this.name, "display format", origFmt);
            }
            Integer iCheck = checkMap.get(this.checkLo.toUpperCase());
            if (iCheck == null) {
                mon.reportError(this.name, "low check option", this.checkLo);
            }
            this.checkLoI = iCheck;
            iCheck = checkMap.get(this.checkHi.toUpperCase());
            if (iCheck == null) {
                mon.reportError(this.name, "high check option", this.checkHi);
            }
            this.checkHiI = iCheck;
            if (this.alarmLo != null) {
                this.alarmLoA = mon.getAlarm(this.alarmLo);
            }
            if (this.alarmLoA == null && (this.checkLoI == 2 || this.alarmLo != null)) {
                mon.reportError(this.name, "low alarm name", this.alarmLo);
            }
            if (this.alarmHi != null) {
                this.alarmHiA = mon.getAlarm(this.alarmHi);
            }
            if (this.alarmHiA == null && (this.checkHiI == 2 || this.alarmHi != null)) {
                mon.reportError(this.name, "high alarm name", this.alarmHi);
            }
            int[] types = this.devc.checkChannel(this.name, this.hwChan, this.type, this.subtype);
            this.typeI = types[0];
            this.subtypeI = types[1];
            this.valid = true;
            this.devc.addChannel(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void configCalc() {
        String[] names = this.subtype.split(":", -1);
        int id0 = 0;
        int id1 = 0;
        try {
            if (names.length != 2 || (id0 = this.mon.getChannelId(names[0])) < 0 || (id1 = this.mon.getChannelId(names[1])) < 0) {
                this.mon.reportError(this.name, "subtype", this.subtype);
            }
            this.subtypeI = id0 << 16 | id1;
        }
        catch (Exception e) {
            this.valid = false;
            this.devc.dropChannel(this.id);
        }
    }

    void initSensor() {
        if (!this.valid) {
            return;
        }
        this.devc.initChannel(this.name, this.id, this.hwChan, this.typeI, this.subtypeI);
    }

    void readSensor() {
        double val = !this.valid || !this.devc.isOnline() ? Double.NaN : this.devc.readChannel(this.hwChan, this.typeI);
        if (!Double.isNaN(val)) {
            this.value = this.offset + this.scale * val;
            this.timestamp = System.currentTimeMillis();
            this.state = 0;
        } else {
            this.state = -1;
        }
    }

    void checkLimits(BitSet cState) {
        if (!this.valid || this.state == -1) {
            return;
        }
        boolean ok = true;
        if (this.value < this.limitLo) {
            if (this.checkLoI != 0) {
                ok = false;
                if (this.checkLoI == 2 && !this.ignrAlarmLo) {
                    this.alarmLoA.updateState(2);
                }
            }
        } else if (this.value > this.limitHi) {
            if (this.checkHiI != 0) {
                ok = false;
                if (this.checkHiI == 2 && !this.ignrAlarmHi) {
                    this.alarmHiA.updateState(2);
                }
            }
        } else {
            if (this.checkLoI == 2 && !this.ignrAlarmLo) {
                this.alarmLoA.updateState(this.value >= this.resetLo ? 0 : 1);
            }
            if (this.checkHiI == 2 && !this.ignrAlarmHi) {
                this.alarmHiA.updateState(this.value <= this.resetHi ? 0 : 1);
            }
        }
        if (ok) {
            cState.set(this.id);
            this.state = 0;
        } else {
            this.state = 2;
        }
    }

    void checkOnline(BitSet cState) {
        cState.set(this.id, this.valid && this.state != -1);
    }

    String getDescription() {
        return this.description;
    }

    String getFormat() {
        return this.format;
    }

    String getUnits() {
        return this.units;
    }

    double getLimitLo() {
        return this.limitLo;
    }

    String getAlarmNameLo() {
        return this.checkLoI == 2 ? this.alarmLo : (this.checkLoI == 1 ? "" : null);
    }

    double getLimitHi() {
        return this.limitHi;
    }

    String getAlarmNameHi() {
        return this.checkHiI == 2 ? this.alarmHi : (this.checkHiI == 1 ? "" : null);
    }

    int getId() {
        return this.id;
    }

    public void enableAlarm(boolean isLow, boolean enable) {
        if (isLow) {
            this.ignrAlarmLo = !enable;
        } else {
            this.ignrAlarmHi = !enable;
        }
    }

    public double getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getState() {
        return this.state;
    }

    public void setValid(boolean isValid) {
        this.valid = isValid;
    }

    public double readValue() {
        if (!this.valid || !this.devc.isOnline()) {
            return Double.NaN;
        }
        return this.offset + this.scale * this.devc.readChannelNow(this.hwChan, this.typeI);
    }

    static {
        checkMap.put("NONE", 0);
        checkMap.put("FLAG", 1);
        checkMap.put("ALARM", 2);
    }
}

