/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.beanutils.MethodUtils;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.utilities.logging.Logger;

public class Sequencer
extends Module {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.sequencer");
    private static final long serialVersionUID = 2620624966948422368L;
    ArrayList<Step> steps = new ArrayList();
    ArrayList<String> sequence = new ArrayList();
    HashMap<String, Label> labels = new HashMap();
    State state = State.HALTED;
    int pc = 0;

    public ArrayList<String> getSequence() {
        return this.sequence;
    }

    public void setSequence(ArrayList<String> sequence) {
        this.sequence = sequence;
    }

    protected void parseSequence() {
        System.out.println(Label.class.getName());
        for (String s : this.sequence) {
            String[] ss = s.split(" +");
            String cls = ss[0].substring(0, 1).toUpperCase() + ss[0].substring(1);
            try {
                Class<?> stepClass = Class.forName(Sequencer.class.getName() + "$" + cls);
                Step instance = (Step)stepClass.newInstance();
                instance.init(ss);
                this.steps.add(instance);
                if (!(instance instanceof Label)) continue;
                this.labels.put(ss[1], (Label)instance);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("cannot interpret step " + s + " class not found"));
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void initModule() {
        this.parseSequence();
    }

    public void start() {
        super.start();
        if (this.labels.containsKey("startup")) {
            this.execute("startup");
        }
    }

    public int findLabel(String label) {
        Label l = this.labels.get(label);
        return this.steps.indexOf(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String label) {
        Sequencer sequencer = this;
        synchronized (sequencer) {
            if (this.state == State.RUNNING) {
                throw new RuntimeException("Sequencer cannot execute if already running");
            }
            this.state = State.RUNNING;
        }
        this.pc = this.findLabel(label);
        do {
            this.pc = this.steps.get(this.pc).execute(this, this.pc);
        } while (this.pc >= 0);
        sequencer = this;
        synchronized (sequencer) {
            this.state = State.HALTED;
        }
    }

    static enum State {
        HALTED,
        RUNNING;

    }

    public static class WaitForProperty
    extends Step {
        String targetModule;
        String property;
        long millis = 20L;

        @Override
        public void init(String[] args) {
            throw new IllegalAccessError("not implemented");
        }
    }

    public static class WaitForUpdate
    extends Step {
        String property;

        @Override
        public void init(String[] args) {
            throw new IllegalAccessError("not implemented");
        }
    }

    public static class Stop
    extends Step {
        @Override
        public void init(String[] args) {
        }

        @Override
        public int execute(Sequencer s, int pc) {
            return -1;
        }
    }

    public static class SleepMillis
    extends Step {
        long millis;

        @Override
        public void init(String[] args) {
            this.millis = Long.parseLong(args[1]);
        }

        @Override
        public int execute(Sequencer s, int pc) {
            try {
                Thread.sleep(this.millis);
            }
            catch (InterruptedException e) {
                log.warn((Object)("interrupted wait " + e));
            }
            return super.execute(s, pc);
        }
    }

    public static class CallMethod
    extends Step {
        String destination;
        String method;

        @Override
        public void init(String[] args) {
            this.destination = args[1];
            this.method = args[2];
        }

        @Override
        public int execute(Sequencer s, int pc) {
            Module m = (Module)s.getComponentByName(this.destination);
            try {
                MethodUtils.invokeMethod((Object)m, (String)this.method, null);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot call method ", e);
            }
            return super.execute(s, pc);
        }
    }

    public static class Label
    extends Step {
        String name;

        @Override
        public void init(String[] args) {
            this.name = args[1];
        }
    }

    public static class Goto
    extends Step {
        String destLabel;

        @Override
        public void init(String[] args) {
            this.destLabel = args[1];
        }

        @Override
        public int execute(Sequencer s, int pc) {
            return s.findLabel(this.destLabel);
        }
    }

    public static abstract class Step {
        public abstract void init(String[] var1);

        public int execute(Sequencer s, int pc) {
            return pc + 1;
        }
    }
}

