package org.lsst.ccs.subsystem.monitor;

import org.lsst.ccs.framework.ConfigurableComponent;

/**
 ******************************************************************************
 **
 **  Implements hardware output lines.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class Line extends ConfigurableComponent {

   /**
    ***************************************************************************
    **
    **  Data fields.
    **
    ***************************************************************************
    */
    // Supplied immutable fields
    private String  devcName;       // Device name
    private int     chan;           // HW channel number
    private String  compDevcName;   // Complementary device name
    private int     compChan;       // Complementary HW channel number

    // Derived immutable fields
    private Device  device;         // Device for this line
    private Device  compDevice;     // Device for the complementary line


    /**
     * The empty constructor
     * TODO: remove when/if other constructor is removed.
     */
    public Line() {
        
    }
    
   /**
    ***************************************************************************
    **
    **  Constructor.
    **
    **  @param  devcName   The name of the associated bit-set device, or
    **                     null if none.
    **
    **  @param  chan       The hardware channel number on the bit-set
    **                     device.
    **
    **  @param  devcNameC  The name of the associated bit-clear device, or
    **                     null if none.
    **
    **  @param  chanC      The hardware channel number on the bit-clear
    **                     device.
    **
    ***************************************************************************
    */
    @Deprecated
    public Line(String devcName, int chan, String devcNameC, int chanC)
    {
        this.devcName  = devcName;
        this.chan      = chan;
        this.compDevcName = devcNameC;
        this.compChan     = chanC;
    }


   /**
    ***************************************************************************
    **
    **  Configures the line.
    **
    **  @param  mon  The associated monitor
    **
    ***************************************************************************
    */
    void configure(Monitor mon)
    {
        try {
            if (devcName != null) {
                device = mon.getDevice(devcName);
                if (device == null) {
                    mon.reportError(getName(), "device", devcName);
                }
                device.checkLine(getName(), chan);
            }
            if (compDevcName != null) {
                compDevice = mon.getDevice(compDevcName);
                if (compDevice == null) {
                    mon.reportError(getName(), "device", compDevcName);
                }
                compDevice.checkLine(getName(), compChan);
            }
        }
        catch(Exception e) {
        }
    }


   /**
    ***************************************************************************
    **
    **  Sets the warm-start state of the line.
    **
    **  @param  on  True to set the warm-start state, false to clear it.
    **
    ***************************************************************************
    */
    public void setWarm(boolean on)
    {
        if (device != null) {
            device.setLineWarm(chan, on);
        }
        if (compDevice != null) {
            compDevice.setLineWarm(compChan, !on);
        }
    }


   /**
    ***************************************************************************
    **
    **  Sets the line value.
    **
    **  @param  on  True to set the line, false to clear it.
    **
    ***************************************************************************
    */
    public void set(boolean on)
    {
        if (device != null && device.online) {
            device.setLine(chan, on);
        }
        if (compDevice != null && compDevice.online) {
            compDevice.setLine(compChan, !on);
        }
    }


   /**
    ***************************************************************************
    **
    **  Gets the line value.
    **
    **  @return  The value of the line: true or false.
    **
    ***************************************************************************
    */
    public boolean isSet()
    {
        boolean state = false;
        if (device != null && device.online) {
            state = device.isLineSet(chan);
        }
        else if (compDevice != null && compDevice.online) {
            state = !compDevice.isLineSet(compChan);
        }

        return state;
    }

}
