package org.lsst.ccs.subsystem.common;

import org.lsst.ccs.utilities.dsp.BoxCarFilter;
import org.lsst.ccs.utilities.dsp.DigitalFilter;
import org.lsst.ccs.utilities.dsp.FilterFactory;
import org.lsst.ccs.utilities.dsp.MedianFilter;

public class Filter extends UnaryOpModule {

	/**
	 * 
	 */
	private static final long serialVersionUID = -793625422091887445L;

	DigitalFilter filterImpl;

	String filterType;

	String[] allowedFilterType = { "median", "boxcar", "highpassfir",
			"lowpassfir", "bandpassfir" };

	double rate; // Hz
	int size;
	double cutFreq1;
	double cutFreq2;
	double attenuation = 20;
	int downSample = 1;

	public String getFilterType() {
		return filterType;
	}

	public void setFilterType(String filterType) {
		this.filterType = filterType;
	}

	public double getRate() {
		return rate;
	}

	public void setRate(double rate) {
		this.rate = rate;
	}

	public int getSize() {
		return size;
	}

	public void setSize(int size) {
		this.size = size;
	}

	public double getCutFreq1() {
		return cutFreq1;
	}

	public void setCutFreq1(double cutFreq1) {
		this.cutFreq1 = cutFreq1;
	}

	public double getCutFreq2() {
		return cutFreq2;
	}

	public void setCutFreq2(double cutFreq2) {
		this.cutFreq2 = cutFreq2;
	}

	public double getAttenuation() {
		return attenuation;
	}

	public void setAttenuation(double attenuation) {
		this.attenuation = attenuation;
	}

	public String[] getAllowedFilterType() {
		return allowedFilterType;
	}

	public void setDownSample(int downSample) {
		this.downSample = downSample;
	}

	public int getDownSample() {
		return downSample;
	}

	long delayMs;

	@Override
	public void initModule() {
		if (filterType.equals("median")) {
			filterImpl = new MedianFilter(size);
		} else if (filterType.equals("boxcar")) {
			filterImpl = new BoxCarFilter(size);
		} else if (filterType.equals("highpassfir")) {
			filterImpl = FilterFactory.getHighPassFIR(rate, attenuation,
					cutFreq1);
		} else if (filterType.equals("lowpassfir")) {
			filterImpl = FilterFactory.getLowPassFIR(rate, attenuation,
					cutFreq1);
		} else if (filterType.equals("bandpassfir")) {
			filterImpl = FilterFactory.getBandPassFIR(rate, attenuation,
					cutFreq1, cutFreq2);
		} else
			throw new IllegalArgumentException("unknown filter type "
					+ filterType);

		delayMs = (long) (1000. / rate * filterImpl.getDelay());
		System.out.println("delay " + delayMs + " (" + filterImpl.getDelay()
				+ ")");
	}

	int nSamples = 0;

	@Override
	public Object processInput(String input, String output, Object val,
			long timeStamp) {
		if (!(val instanceof Double))
			return null;
		double outval = filterImpl.apply((Double) val);
		// TODO optimize, push and not apply if not going to be used
		nSamples++;
		if (nSamples < downSample)
			return null;
		nSamples = 0;

		setChanged();
		notifyObservers(new ValueUpdate(output, outval, timeStamp - delayMs));

		return null;
	}

}
