/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.common.UnaryOpModule;
import org.lsst.ccs.utilities.dsp.BoxCarFilter;
import org.lsst.ccs.utilities.dsp.DigitalFilter;
import org.lsst.ccs.utilities.dsp.FilterFactory;
import org.lsst.ccs.utilities.dsp.MedianFilter;

public class Filter
extends UnaryOpModule {
    private static final long serialVersionUID = -793625422091887445L;
    DigitalFilter filterImpl;
    String filterType;
    String[] allowedFilterType = new String[]{"median", "boxcar", "highpassfir", "lowpassfir", "bandpassfir"};
    double rate;
    int size;
    double cutFreq1;
    double cutFreq2;
    double attenuation = 20.0;
    int downSample = 1;
    long delayMs;
    int nSamples = 0;

    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public double getCutFreq1() {
        return this.cutFreq1;
    }

    public void setCutFreq1(double cutFreq1) {
        this.cutFreq1 = cutFreq1;
    }

    public double getCutFreq2() {
        return this.cutFreq2;
    }

    public void setCutFreq2(double cutFreq2) {
        this.cutFreq2 = cutFreq2;
    }

    public double getAttenuation() {
        return this.attenuation;
    }

    public void setAttenuation(double attenuation) {
        this.attenuation = attenuation;
    }

    public String[] getAllowedFilterType() {
        return this.allowedFilterType;
    }

    public void setDownSample(int downSample) {
        this.downSample = downSample;
    }

    public int getDownSample() {
        return this.downSample;
    }

    public void initModule() {
        if (this.filterType.equals("median")) {
            this.filterImpl = new MedianFilter(this.size);
        } else if (this.filterType.equals("boxcar")) {
            this.filterImpl = new BoxCarFilter(this.size);
        } else if (this.filterType.equals("highpassfir")) {
            this.filterImpl = FilterFactory.getHighPassFIR((double)this.rate, (double)this.attenuation, (double)this.cutFreq1);
        } else if (this.filterType.equals("lowpassfir")) {
            this.filterImpl = FilterFactory.getLowPassFIR((double)this.rate, (double)this.attenuation, (double)this.cutFreq1);
        } else if (this.filterType.equals("bandpassfir")) {
            this.filterImpl = FilterFactory.getBandPassFIR((double)this.rate, (double)this.attenuation, (double)this.cutFreq1, (double)this.cutFreq2);
        } else {
            throw new IllegalArgumentException("unknown filter type " + this.filterType);
        }
        this.delayMs = (long)(1000.0 / this.rate * (double)this.filterImpl.getDelay());
        System.out.println("delay " + this.delayMs + " (" + this.filterImpl.getDelay() + ")");
    }

    @Override
    public Object processInput(String input, String output, Object val, long timeStamp) {
        if (!(val instanceof Double)) {
            return null;
        }
        double outval = this.filterImpl.apply(((Double)val).doubleValue());
        ++this.nSamples;
        if (this.nSamples < this.downSample) {
            return null;
        }
        this.nSamples = 0;
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, output, (Object)outval, timeStamp - this.delayMs));
        return null;
    }
}

