package org.lsst.ccs.subsystem.common;

/**
 * Proportional-Integral-Derivative feedback loop
 * 
 * @author aubourg
 * 
 */
public class PIDFeedbackLoop extends FeedbackLoop {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3571632351421804795L;
	double gain = 0.01;
	double integralTime = 1;
	double derivativeTime = 1;

	double maxCorr = 50;
	double minCorr = 0;

	double lastCorr = 0;
	long setupChangeTime = 0;

	boolean freezeOnUpdate = true;
	boolean progressiveParmUpdates = false; // TODO

	public void setFreezeOnUpdate(boolean freezeOnUpdate) {
		this.freezeOnUpdate = freezeOnUpdate;
	}

	public boolean isFreezeOnUpdate() {
		return freezeOnUpdate;
	}

	public void changeSetup() {
		setupChangeTime = System.currentTimeMillis();
		resetIntegral();
	}

	@Override
	public void setTarget(double target) {
		changeSetup();
		super.setTarget(target);
	}

	public double getGain() {
		return gain;
	}

	public void setGain(double gain) {
		this.gain = gain;
		changeSetup();
	}

	public double getIntegralTime() {
		return integralTime;
	}

	public void setIntegralTime(double integralTime) {
		this.integralTime = integralTime;
		changeSetup();
	}

	public double getDerivativeTime() {
		return derivativeTime;
	}

	public void setDerivativeTime(double derivativeTime) {
		this.derivativeTime = derivativeTime;
	}

	// derivative buffering ?

	double lastTime = 0;
	double lastErrorValue;
	double integral = 0;

	long minDelay = 2;

	public void resetIntegral() {
		integral = 0;
	}

	public void setMinCorr(double minCorr) {
		this.minCorr = minCorr;
	}

	public void setMaxCorr(double maxCorr) {
		this.maxCorr = maxCorr;
	}

	public double getMinCorr() {
		return minCorr;
	}

	public double getMaxCorr() {
		return maxCorr;
	}

	@Override
	public Object processInput(String input, String output, Object val,
			long timeStamp) {
		if (timeStamp - lastTime < minDelay)
			return null;
		double error = (Double) val - target;
		integral += error;
		double der = (error - lastErrorValue) / (timeStamp - lastTime);

		double corr = -gain
				* (error + integral / integralTime + der * derivativeTime);

		if (corr > maxCorr) {
			corr = maxCorr;
		}
		if (corr < minCorr) {
			corr = minCorr;
		}

		lastTime = timeStamp;
		lastErrorValue = error;

		if (freezeOnUpdate
				&& (timeStamp - setupChangeTime < integralTime * 1000L / 4 || timeStamp
						- setupChangeTime < derivativeTime * 1000L / 4)) {
			corr = lastCorr;
		} else {
			lastCorr = corr;
		}

		return corr;
	}

}
