/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.utilities.logging.Logger;

public class Channel
extends ConfigurableComponent {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_TEMP = 0;
    public static final int TYPE_VOLTS = 1;
    public static final int TYPE_POWER = 2;
    public static final int TYPE_SWITCH = 3;
    public static final int TYPE_DIFF = 4;
    public static final int STATE_OFFLINE = -1;
    public static final int STATE_GOOD = 0;
    public static final int STATE_WARNING = 1;
    public static final int STATE_ERROR = 2;
    private static final int LIMIT_CHECK_NONE = 0;
    private static final int LIMIT_CHECK_FLAG = 1;
    private static final int LIMIT_CHECK_ALARM = 2;
    private static final Map<String, Integer> checkMap = new HashMap<String, Integer>();
    private final String description;
    private final String units;
    private final String devcName;
    private final int hwChan;
    private final String typeS;
    private final String subtypeS;
    private final double offset;
    private final double scale;
    private final String checkLoS;
    private final String alarmLoS;
    private final double dbandLo;
    private final String checkHiS;
    private final String alarmHiS;
    private final double dbandHi;
    private String format;
    private double limitLo;
    private double limitHi;
    private String name;
    private Device devc;
    private int type;
    private int subtype;
    private int checkLo;
    private Alarm alarmLo;
    private int checkHi;
    private Alarm alarmHi;
    private int id;
    private boolean valid;
    private Monitor mon;
    private Logger log;
    private double value;
    private long timestamp;
    private int state;
    private double resetLo;
    private double resetHi;
    private boolean ignrAlarmLo;
    private boolean ignrAlarmHi;

    public Channel(String desc, String fmt, String unit, String devName, int chan, String type, String subtype, double offs, double scal, String checkLo, double limLo, double deadbandLo, String alarmLo, String checkHi, double limHi, double deadbandHi, String alarmHi) {
        this.description = desc;
        this.format = fmt;
        this.units = unit;
        this.devcName = devName == null ? "Calc" : devName;
        this.hwChan = chan;
        this.typeS = type;
        this.subtypeS = subtype;
        this.offset = offs;
        this.scale = scal;
        this.checkLoS = checkLo;
        this.limitLo = limLo;
        this.dbandLo = deadbandLo;
        this.resetLo = this.dbandLo <= 0.0 ? this.limitLo : this.limitLo + this.dbandLo;
        this.alarmLoS = alarmLo;
        this.checkHiS = checkHi;
        this.limitHi = limHi;
        this.dbandHi = deadbandHi;
        this.resetHi = this.dbandHi <= 0.0 ? this.limitHi : this.limitHi - this.dbandHi;
        this.alarmHiS = alarmHi;
        this.state = -1;
    }

    public Channel(String desc, String unit, String devName, int chan, String type, String subtype, double offs, double scal, String checkLo, double limLo, double deadbandLo, String alarmLo, String checkHi, double limHi, double deadbandHi, String alarmHi) {
        this(desc, null, unit, devName, chan, type, subtype, offs, scal, checkLo, limLo, deadbandLo, alarmLo, checkHi, limHi, deadbandHi, alarmHi);
    }

    void configure(Monitor mon, int id) {
        this.name = this.getName();
        this.mon = mon;
        this.id = id;
        this.log = mon.log;
        this.checkLo = 1;
        this.checkHi = 1;
        this.type = -1;
        this.subtype = -1;
        try {
            Integer iCheck;
            this.devc = mon.getDevice(this.devcName);
            if (this.devc == null) {
                mon.reportError(this.name, "device name", this.devcName);
            }
            if (this.format != null && !this.format.isEmpty()) {
                String origFmt = this.format;
                try {
                    if (this.format.charAt(0) != '%') {
                        this.format = "%" + this.format;
                    }
                    this.format = this.format + " ";
                    String string = String.format(this.format, 0.0);
                }
                catch (IllegalFormatException e) {
                    this.format = "%s ";
                    mon.reportError(this.name, "display format", origFmt);
                }
            } else {
                this.format = "%.2f ";
            }
            if ((iCheck = checkMap.get(this.checkLoS.toUpperCase())) == null) {
                mon.reportError(this.name, "low check option", this.checkLoS);
            }
            this.checkLo = iCheck;
            iCheck = checkMap.get(this.checkHiS.toUpperCase());
            if (iCheck == null) {
                mon.reportError(this.name, "high check option", this.checkHiS);
            }
            this.checkHi = iCheck;
            if (this.alarmLoS != null) {
                this.alarmLo = mon.getAlarm(this.alarmLoS);
            }
            if (this.alarmLo == null && (this.checkLo == 2 || this.alarmLoS != null)) {
                mon.reportError(this.name, "low alarm name", this.alarmLoS);
            }
            if (this.alarmHiS != null) {
                this.alarmHi = mon.getAlarm(this.alarmHiS);
            }
            if (this.alarmHi == null && (this.checkHi == 2 || this.alarmHiS != null)) {
                mon.reportError(this.name, "high alarm name", this.alarmHiS);
            }
            int[] types = this.devc.checkChannel(this.name, this.hwChan, this.typeS, this.subtypeS);
            this.type = types[0];
            this.subtype = types[1];
            this.valid = true;
            this.devc.addChannel(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void configCalc() {
        String[] names = this.subtypeS.split(":", -1);
        int id0 = 0;
        int id1 = 0;
        try {
            if (names.length != 2 || (id0 = this.mon.getChannelId(names[0])) < 0 || (id1 = this.mon.getChannelId(names[1])) < 0) {
                this.mon.reportError(this.name, "subtype", this.subtypeS);
            }
            this.subtype = id0 << 16 | id1;
        }
        catch (Exception e) {
            this.valid = false;
            this.devc.dropChannel(this.id);
        }
    }

    void initSensor() {
        if (!this.valid) {
            return;
        }
        this.devc.initChannel(this.name, this.id, this.hwChan, this.type, this.subtype);
    }

    void readSensor() {
        double val;
        if (!this.valid || !this.devc.isOnline()) {
            val = Double.NaN;
        } else if (this.devc != this.mon.calcDevc) {
            val = this.offset + this.scale * this.devc.readChannel(this.hwChan, this.type);
        } else {
            Channel chan1 = this.mon.getChannel(this.subtype >> 16);
            Channel chan2 = this.mon.getChannel(this.subtype & 0xFFFF);
            val = chan1.state != -1 && chan2.state != -1 ? chan1.value - chan2.value : Double.NaN;
        }
        if (!Double.isNaN(val)) {
            this.value = val;
            this.timestamp = System.currentTimeMillis();
            this.state = 0;
        } else {
            this.state = -1;
        }
    }

    void checkLimits(BitSet cState) {
        if (!this.valid || this.state == -1) {
            return;
        }
        boolean ok = true;
        if (this.value < this.limitLo) {
            if (this.checkLo != 0) {
                ok = false;
                if (this.checkLo == 2 && !this.ignrAlarmLo) {
                    this.alarmLo.updateState(2);
                }
            }
        } else if (this.value > this.limitHi) {
            if (this.checkHi != 0) {
                ok = false;
                if (this.checkHi == 2 && !this.ignrAlarmHi) {
                    this.alarmHi.updateState(2);
                }
            }
        } else {
            if (this.checkLo == 2 && !this.ignrAlarmLo) {
                this.alarmLo.updateState(this.value >= this.resetLo ? 0 : 1);
            }
            if (this.checkHi == 2 && !this.ignrAlarmHi) {
                this.alarmHi.updateState(this.value <= this.resetHi ? 0 : 1);
            }
        }
        if (ok) {
            cState.set(this.id);
            this.state = 0;
        } else {
            this.state = 2;
        }
    }

    String getDescription() {
        return this.description;
    }

    String getFormat() {
        return this.format;
    }

    String getUnits() {
        return this.units;
    }

    double getLimitLo() {
        return this.limitLo;
    }

    String getAlarmNameLo() {
        return this.checkLo == 2 ? this.alarmLoS : (this.checkLo == 1 ? "" : null);
    }

    double getLimitHi() {
        return this.limitHi;
    }

    String getAlarmNameHi() {
        return this.checkHi == 2 ? this.alarmHiS : (this.checkHi == 1 ? "" : null);
    }

    int getId() {
        return this.id;
    }

    @ConfigChanger
    public void setLimitLo(double limit) {
        if (!this.valid || limit == this.limitLo) {
            return;
        }
        this.limitLo = limit;
        this.resetLo = this.dbandLo <= 0.0 ? this.limitLo : this.limitLo + this.dbandLo;
        this.mon.loLimChange.set(this.id);
        KeyValueDataList data = new KeyValueDataList(this.name);
        data.addData("alarmLow", (Serializable)((Object)String.valueOf(limit)), KeyValueData.KeyValueDataType.KeyValueMetaData);
        this.mon.subsys.publishSubsystemDataOnStatusBus((KeyValueData)data);
        this.mon.publishState();
    }

    @ConfigChanger
    public void setLimitHi(double limit) {
        if (!this.valid || limit == this.limitHi) {
            return;
        }
        this.limitHi = limit;
        this.resetHi = this.dbandHi <= 0.0 ? this.limitHi : this.limitHi - this.dbandHi;
        this.mon.hiLimChange.set(this.id);
        KeyValueDataList data = new KeyValueDataList(this.name);
        data.addData("alarmHigh", (Serializable)((Object)String.valueOf(limit)), KeyValueData.KeyValueDataType.KeyValueMetaData);
        this.mon.subsys.publishSubsystemDataOnStatusBus((KeyValueData)data);
        this.mon.publishState();
    }

    public void enableAlarm(boolean isLow, boolean enable) {
        if (isLow) {
            this.ignrAlarmLo = !enable;
        } else {
            this.ignrAlarmHi = !enable;
        }
    }

    public double getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getState() {
        return this.state;
    }

    static {
        checkMap.put("NONE", 0);
        checkMap.put("FLAG", 1);
        checkMap.put("ALARM", 2);
    }
}

