package org.lsst.ccs.subsystem.common;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.lsst.ccs.bus.data.KeyValueData;

public class UpdateValuePublisher extends UnaryOpModule {

    protected static Logger log = Logger.getLogger("lsst.ccs.modular");

    @Override
    public Object processInput(String input, String output, Object val,
            long timeStamp) {
        log.info("publishing " + input + "/" + output + "/"
                + val);
        KeyValueData d = new KeyValueData(output,(Serializable)val);
//        getSubsystem().publishStatus(output, val);
        getSubsystem().publishSubsystemDataOnStatusBus(d);
        	
        return null;
    }
}
