package org.lsst.ccs.subsystem.common;

import java.util.HashMap;

/**
 * Time derivative. Not protected against noise, to be applied to filtered
 * signal
 * 
 * @author aubourg
 * 
 */
public class TimeDerivative extends UnaryOpModule {

    private static final long serialVersionUID = 1651568845441246380L;

    class Point {
		Point(long t, double d) {
			time = t;
			data = d;
		}

		long time;
		double data;
	}

	HashMap<String, Point> lastPoint = new HashMap<String, Point>();

	@Override
	public Object processInput(String input, String output, Object val,
			long timeStamp) {
		Point p = lastPoint.get(input);
		Double result = null;
		if (p != null) {
			if (p.time < timeStamp)
				result = ((Double) val - p.data) / (timeStamp - p.time)*1000;;
		}

		lastPoint.put(input, new Point(timeStamp, (Double) val));
		return result;
	}

}
