package org.lsst.ccs.subsystem.common;

import java.util.Observable;

import org.lsst.ccs.framework.Module;

/**
 * Monitors a value and set alarms if goes below/above thresholds
 * 
 * An alarm message is sent when variable goes above highLimit or below
 * lowLimit. An alarm cleared message is sent when variable goes back between
 * lowLimitClear and highLimitClear
 * 
 * @author aubourg
 * 
 */

public class ThresholdMonitor extends Module {
	/**
	 * 
	 */
	private static final long serialVersionUID = -8306607108474223745L;
	String input;
	double lowLimit = -Double.MAX_VALUE;
	double highLimit = Double.MAX_VALUE;
	double lowLimitClear = -Double.MAX_VALUE;
	double highLimitClear = Double.MAX_VALUE;

	enum State {
		OK, LOW_ALARM, HIGH_ALARM
	}

	State state = State.OK;

	public String getInput() {
		return input;
	}

	public void setInput(String input) {
		this.input = input;
	}

	public double getLowLimit() {
		return lowLimit;
	}

	public void setLowLimit(double lowLimit) {
		this.lowLimit = lowLimit;
	}

	public double getHighLimit() {
		return highLimit;
	}

	public void setHighLimit(double highLimit) {
		this.highLimit = highLimit;
	}

	public double getLowLimitClear() {
		return lowLimitClear;
	}

	public void setLowLimitClear(double lowLimitClear) {
		this.lowLimitClear = lowLimitClear;
	}

	public double getHighLimitClear() {
		return highLimitClear;
	}

	public void setHighLimitClear(double highLimitClear) {
		this.highLimitClear = highLimitClear;
	}

	public State getState() {
		return state;
	}

	@Override
	public void processUpdate(Observable source, ValueUpdate update) {
		if (update.getName().equals(input)) {
			double x = (Double) update.getValue();
			switch (state) {
			case OK:
				if (x > highLimit) {
					state = State.HIGH_ALARM;
					setAlarm();
				} else if (x < lowLimit) {
					state = State.LOW_ALARM;
					setAlarm();
				}
				break;
			case HIGH_ALARM:
				if (x < lowLimit) {
					state = State.LOW_ALARM;
					setAlarm();

				} else if (x < highLimitClear) {
					state = State.OK;
					clearAlarm();
				}
				break;
			case LOW_ALARM:
				if (x > highLimit) {
					state = State.HIGH_ALARM;
					setAlarm();

				} else if (x > lowLimitClear) {
					state = State.OK;
					clearAlarm();
				}
				break;
			}
		}
	}

	protected void setAlarm() {
		String message = "Alarm " + state + " on " + input;
		log.error(message);
		getSubsystem().raiseAlarm(message);
	}

	protected void clearAlarm() {
		String message = "Alarm cleared on " + input;
		log.info(message);
		getSubsystem().clearAlarms(message);
	}

}
