/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.EncodedDataStatus;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.CalcDevice;
import org.lsst.ccs.subsystem.monitor.Channel;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.data.MonitorChan;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.utilities.logging.Logger;

public class Monitor {
    private static final int DEFAULT_UPDATE_PERIOD = 1000;
    private static final int DEFAULT_CHECK_PERIOD = 10000;
    static final String CALC_DEVICE_NAME = "Calc";
    private final Module module;
    private final Map<String, Device> devcMap;
    private final Map<String, Channel> chanMap;
    private final Map<String, Alarm> alarmMap;
    private final Map<String, Line> lineMap;
    private final List<Device> devcList = new ArrayList<Device>();
    private final List<Alarm> alarmList = new ArrayList<Alarm>();
    private final BitSet goodChans = new BitSet();
    private final BitSet onlineChans = new BitSet();
    final AlarmHandler alarmH;
    final Logger log;
    final CalcDevice calcDevc = new CalcDevice();
    final Subsystem subsys;
    final BitSet loLimChange = new BitSet();
    final BitSet hiLimChange = new BitSet();
    private int numChans;
    private Channel[] chanData;

    public Monitor(Module mod, AlarmHandler alarmHand, Logger logger) {
        this.module = mod;
        this.alarmH = alarmHand;
        this.log = logger;
        this.subsys = this.module.getSubsystem();
        this.devcMap = this.module.getChildren(Device.class);
        this.chanMap = this.module.getChildren(Channel.class);
        this.alarmMap = this.module.getChildren(Alarm.class);
        this.lineMap = this.module.getChildren(Line.class);
    }

    public void initConfiguration() {
        this.devcMap.put(CALC_DEVICE_NAME, this.calcDevc);
        for (Device devc : this.devcMap.values()) {
            this.devcList.add(devc);
            devc.configure(this);
        }
        for (Line line : this.lineMap.values()) {
            line.configure(this);
        }
        for (Alarm alarm : this.alarmMap.values()) {
            this.alarmList.add(alarm);
            alarm.configure(this);
        }
        this.chanData = new Channel[this.chanMap.size()];
        int id = 0;
        for (Channel ch : this.chanMap.values()) {
            ch.configure(this, id);
            this.chanData[id++] = ch;
        }
        this.calcDevc.configChans();
    }

    public void initSensors() {
        this.initSensors(10000);
    }

    public void initSensors(int checkPeriod) {
        if (checkPeriod <= 0) {
            checkPeriod = 10000;
        }
        for (Device devc : this.devcList) {
            if (devc.disabled) continue;
            devc.initialize();
        }
        for (Alarm alarm : this.alarmList) {
            alarm.initialize();
        }
        new Timer("CheckDevices", true).schedule((TimerTask)new CheckDevices(), 0L, (long)checkPeriod);
    }

    public void readSensors() {
        for (Device devc : this.devcList) {
            devc.readSensors();
        }
    }

    public void start() {
        this.start(1000);
    }

    public void start(int period) {
        new Timer("UpdateState", true).schedule((TimerTask)new UpdateState(), 0L, (long)period);
    }

    public MonitorFullState getFullState() {
        MonitorFullState state = new MonitorFullState();
        for (Alarm alarm : this.alarmList) {
            state.addAlarm(alarm.getName(), alarm.getDescription());
        }
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            state.addChannel(new MonitorChan(ch.getName(), ch.getDescription(), ch.getFormat(), ch.getUnits(), ch.getLimitLo(), ch.getAlarmNameLo(), ch.getLimitHi(), ch.getAlarmNameHi(), ch.getValue()));
            ++n2;
        }
        state.setMonitorState(new MonitorState(this.goodChans, this.onlineChans, this.loLimChange, this.hiLimChange));
        return state;
    }

    public void publishState() {
        MonitorState state = new MonitorState(this.goodChans, this.onlineChans, this.loLimChange, this.hiLimChange);
        this.subsys.publishStatus("MonitorState", (Object)state);
    }

    public void publishData() {
        EncodedDataStatus eds = null;
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            if (ch.getState() != -1) {
                eds = EncodedDataStatus.addData(eds, (long)ch.getTimestamp(), (String)ch.getName(), (Object)ch.getValue());
            }
            ++n2;
        }
        if (eds != null) {
            this.subsys.sendRawStatus(eds);
        }
    }

    public void publishLimits() {
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            this.subsys.publishMetaData(ch.getName(), "alarmLow", String.valueOf(ch.getLimitLo()));
            this.subsys.publishMetaData(ch.getName(), "alarmHigh", String.valueOf(ch.getLimitHi()));
            ++n2;
        }
    }

    public void checkLimits() {
        BitSet chanState = new BitSet(this.numChans);
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            ch.checkLimits(chanState);
            ++n2;
        }
        for (Alarm alarm : this.alarmList) {
            alarm.setState();
        }
        chanState.xor(this.goodChans);
        this.goodChans.xor(chanState);
        if (!chanState.isEmpty()) {
            this.publishState();
            this.publishData();
        }
    }

    public void clearLimitChanges() {
        this.loLimChange.clear();
        this.hiLimChange.clear();
    }

    public Device getDevice(String name) {
        return this.devcMap.get(name);
    }

    public Line getLine(String name) {
        return this.lineMap.get(name);
    }

    public Alarm getAlarm(String name) {
        return this.alarmMap.get(name);
    }

    public Channel getChannel(String name) {
        return this.chanMap.get(name);
    }

    public Channel getChannel(int id) {
        return this.chanData[id];
    }

    public int getChannelId(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? -1 : chan.getId();
    }

    public void setOnline(BitSet mask, boolean online) {
        BitSet prevOnline = (BitSet)this.onlineChans.clone();
        if (online) {
            this.onlineChans.or(mask);
        } else {
            this.onlineChans.andNot(mask);
        }
        if (!this.onlineChans.equals(prevOnline)) {
            this.publishState();
        }
    }

    public int getNumChans() {
        return this.numChans;
    }

    public Module getModule() {
        return this.module;
    }

    public void reportError(String cName, String pName, Object pValue) throws Exception {
        this.log.error((Object)("Invalid " + pName + " (" + pValue + ") for " + cName));
        throw new Exception();
    }

    public void reportConfigError(String cName, String pName, String message) {
        this.log.error((Object)("Configuration parameter " + pName + " for " + cName + " " + message));
        throw new RuntimeException("Fatal configuration error");
    }

    public static interface AlarmHandler {
        public void processAlarm(int var1, int var2);
    }

    private class CheckDevices
    extends TimerTask {
        private CheckDevices() {
        }

        @Override
        public void run() {
            for (Device devc : Monitor.this.devcList) {
                devc.checkOnline();
            }
        }
    }

    private class UpdateState
    extends TimerTask {
        private UpdateState() {
        }

        @Override
        public void run() {
            Monitor.this.readSensors();
            Monitor.this.checkLimits();
        }
    }
}

