/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import org.lsst.ccs.subsystem.common.FeedbackLoop;

public class PIDFeedbackLoop
extends FeedbackLoop {
    private static final long serialVersionUID = -3571632351421804795L;
    double gain = 0.01;
    double integralTime = 1.0;
    double derivativeTime = 1.0;
    double maxCorr = 50.0;
    double minCorr = 0.0;
    double lastCorr = 0.0;
    long setupChangeTime = 0L;
    boolean freezeOnUpdate = true;
    boolean progressiveParmUpdates = false;
    double lastTime = 0.0;
    double lastErrorValue;
    double integral = 0.0;
    long minDelay = 2L;

    public void setFreezeOnUpdate(boolean freezeOnUpdate) {
        this.freezeOnUpdate = freezeOnUpdate;
    }

    public boolean isFreezeOnUpdate() {
        return this.freezeOnUpdate;
    }

    public void changeSetup() {
        this.setupChangeTime = System.currentTimeMillis();
        this.resetIntegral();
    }

    @Override
    public void setTarget(double target) {
        this.changeSetup();
        super.setTarget(target);
    }

    public double getGain() {
        return this.gain;
    }

    public void setGain(double gain) {
        this.gain = gain;
        this.changeSetup();
    }

    public double getIntegralTime() {
        return this.integralTime;
    }

    public void setIntegralTime(double integralTime) {
        this.integralTime = integralTime;
        this.changeSetup();
    }

    public double getDerivativeTime() {
        return this.derivativeTime;
    }

    public void setDerivativeTime(double derivativeTime) {
        this.derivativeTime = derivativeTime;
    }

    public void resetIntegral() {
        this.integral = 0.0;
    }

    public void setMinCorr(double minCorr) {
        this.minCorr = minCorr;
    }

    public void setMaxCorr(double maxCorr) {
        this.maxCorr = maxCorr;
    }

    public double getMinCorr() {
        return this.minCorr;
    }

    public double getMaxCorr() {
        return this.maxCorr;
    }

    @Override
    public Object processInput(String input, String output, Object val, long timeStamp) {
        if ((double)timeStamp - this.lastTime < (double)this.minDelay) {
            return null;
        }
        double error = (Double)val - this.target;
        this.integral += error;
        double der = (error - this.lastErrorValue) / ((double)timeStamp - this.lastTime);
        double corr = -this.gain * (error + this.integral / this.integralTime + der * this.derivativeTime);
        if (corr > this.maxCorr) {
            corr = this.maxCorr;
        }
        if (corr < this.minCorr) {
            corr = this.minCorr;
        }
        this.lastTime = timeStamp;
        this.lastErrorValue = error;
        if (this.freezeOnUpdate && ((double)(timeStamp - this.setupChangeTime) < this.integralTime * 1000.0 / 4.0 || (double)(timeStamp - this.setupChangeTime) < this.derivativeTime * 1000.0 / 4.0)) {
            corr = this.lastCorr;
        } else {
            this.lastCorr = corr;
        }
        return corr;
    }
}

