package org.lsst.ccs.subsystem.common;

import java.util.Observable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.lsst.ccs.framework.Module;

public abstract class UnaryOpModule extends Module {

	/**
	 * 
	 */
	private static final long serialVersionUID = 669697625841733800L;

	public UnaryOpModule() {
		super();
	}

	String prefix;
	String attRegex; // regexp. If not null, source attribute should match
	// if valueNameFilter has a capturing group then valueName will be a prefix
	// followed by
	// the captured group
	String suffix;

	Pattern pat;

	public String getPrefix() {
		return prefix;
	}

	/**
	 * Prefix that will be added, if defined, to output name
	 */

	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	public String getSuffix() {
		return suffix;
	}

	/**
	 * Suffix that will be added, if defined, to output name
	 */
	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}

	/**
	 * regex to select which attributes of the observed modules will be
	 * processed. output property will have the prefix added if defined if the
	 * regex has a capturing group it will be used to build the output property
	 * name instead of the input property name
	 */

	public void setAttRegex(String attRegex) {
		this.attRegex = attRegex;
		pat = Pattern.compile(attRegex);
	}

	public String getAttRegex() {
		return attRegex;
	}

	public abstract Object processInput(String input, String output,
			Object val, long timeStamp);

	@Override
	public void processUpdate(Observable source, ValueUpdate update) {
		StringBuilder publishName = new StringBuilder();
		if (prefix != null) {
			publishName.append(prefix);
		}
		if (pat != null) {
			Matcher m = pat.matcher(update.getName());
			if (!m.matches())
				return;
			String grp = null;
			if (m.groupCount() > 0)
				grp = m.group(1);
			if (grp != null) {
				publishName.append(grp);
			} else {
				publishName.append(update.getName());
			}
		} else {
			publishName.append(update.getName());
		}
		if (suffix != null) {
			publishName.append(suffix);
		}
		Object res = processInput(update.getName(), publishName.toString(),
				update.getValue(), update.getTimeStamp());
		if (res != null) {
			setChanged();
			notifyObservers(new ValueUpdate(publishName.toString(), res, update
					.getTimeStamp()));
		}

	}
}