/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.util.HashMap;
import org.lsst.ccs.subsystem.common.UnaryOpModule;

public class TimeDerivative
extends UnaryOpModule {
    private static final long serialVersionUID = 1651568845441246380L;
    HashMap<String, Point> lastPoint = new HashMap();

    @Override
    public Object processInput(String input, String output, Object val, long timeStamp) {
        Point p = this.lastPoint.get(input);
        Double result = null;
        if (p != null && p.time < timeStamp) {
            result = ((Double)val - p.data) / (double)(timeStamp - p.time) * 1000.0;
        }
        this.lastPoint.put(input, new Point(timeStamp, (Double)val));
        return result;
    }

    class Point {
        long time;
        double data;

        Point(long t, double d) {
            this.time = t;
            this.data = d;
        }
    }
}

