package org.lsst.ccs.subsystem.monitor;

import java.util.HashMap;
import java.util.Map;

/**
 ******************************************************************************
 **
 **  "Device" for performing calculations.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class CalcDevice extends Device {

   /**
    ***************************************************************************
    **
    **  Private lookup maps.
    **
    ***************************************************************************
    */
    private final static Map<String,Integer> typeMap = new HashMap<>();
    static {
        typeMap.put("DIFF", Channel.TYPE_DIFF);
    }


   /**
    ***************************************************************************
    **
    **  Performs basic initialization.
    **
    ***************************************************************************
    */
    @Override
    protected void initialize()
    {
        setOnline(true);
    }


   /**
    ***************************************************************************
    **
    **  Closes the connection.
    **
    ***************************************************************************
    */
    @Override
    protected void close()
    {
    }


   /**
    ***************************************************************************
    **
    **  Checks a channel's parameters for validity.
    **
    **  @param  name     The name of the channel.
    **
    **  @param  hwChan   The hardware channel number.
    **
    **  @param  type     The channel type string.
    **
    **  @param  subtype  The channel subtype string.
    **
    **  @return  A two-element array containing the encoded type [0] and
    **           subtype [1].
    **
    **  @throws  Exception if any errors found in the parameters
    **
    ***************************************************************************
    */
    @Override
    protected int[] checkChannel(String name, int hwChan, String type,
                                 String subtype) throws Exception
    {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            mon.reportError(name, "type", type);
        }

        return new int[]{iType, 0};
    }


   /**
    ***************************************************************************
    **
    **  Completes channel configuration.
    **
    ***************************************************************************
    */
    void configChans()
    {
        for (int id = chanMask.nextSetBit(0); id >= 0;
             id = chanMask.nextSetBit(id + 1)) {
            mon.getChannel(id).configCalc();
        }
    }

}
