/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.util.Observable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.framework.Module;

public abstract class UnaryOpModule
extends Module {
    private static final long serialVersionUID = 669697625841733800L;
    String prefix;
    String attRegex;
    String suffix;
    Pattern pat;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setAttRegex(String attRegex) {
        this.attRegex = attRegex;
        this.pat = Pattern.compile(attRegex);
    }

    public String getAttRegex() {
        return this.attRegex;
    }

    public abstract Object processInput(String var1, String var2, Object var3, long var4);

    public void processUpdate(Observable source, Module.ValueUpdate update) {
        Object res;
        StringBuilder publishName = new StringBuilder();
        if (this.prefix != null) {
            publishName.append(this.prefix);
        }
        if (this.pat != null) {
            Matcher m = this.pat.matcher(update.getName());
            if (!m.matches()) {
                return;
            }
            String grp = null;
            if (m.groupCount() > 0) {
                grp = m.group(1);
            }
            if (grp != null) {
                publishName.append(grp);
            } else {
                publishName.append(update.getName());
            }
        } else {
            publishName.append(update.getName());
        }
        if (this.suffix != null) {
            publishName.append(this.suffix);
        }
        if ((res = this.processInput(update.getName(), publishName.toString(), update.getValue(), update.getTimeStamp())) != null) {
            this.setChanged();
            this.notifyObservers(new Module.ValueUpdate((Module)this, publishName.toString(), res, update.getTimeStamp()));
        }
    }
}

