package org.lsst.ccs.subsystem.monitor;

import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.utilities.logging.Logger;

/**
 ******************************************************************************
 **
 **  Implements a control "channel".
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public abstract class Control extends ConfigurableComponent {

   /**
    ***************************************************************************
    **
    **  Data fields.
    **
    ***************************************************************************
    */
    // Supplied immutable fields
    protected final String  description;   // Channel description
    protected final int     hwChan;        // HW channel number

    // Derived immutable fields
    protected Device  devc;          // Associated device object
    protected Monitor mon;           // Associated monitor object
    protected Logger  log;           // Message logger


   /**
    ***************************************************************************
    **
    **  Constructor.
    **
    **  @param  desc    The descriptive name
    **
    **  @param  hwChan  The hardware channel number
    **
    ***************************************************************************
    */
    public Control(String desc, int hwChan)
    {
        this.description = desc;
        this.hwChan = hwChan;
    }


   /**
    ***************************************************************************
    **
    **  Configures common part of control channel.
    **
    **  @param  mon   The associated monitor
    **
    **  @param  devc  The associated device
    **
    ***************************************************************************
    */
    protected void configure(Monitor mon, Device devc)
    {
        this.mon = mon;
        this.devc = devc;
        log = mon.log;
    }


   /**
    ***************************************************************************
    **
    **  Gets the channel description.
    **
    **  @return  The description
    **
    ***************************************************************************
    */
    public String getDescription()
    {
        return description;
    }


   /**
    ***************************************************************************
    **
    **  Gets the hardware channel number.
    **
    **  @return  The hardware channel number
    **
    ***************************************************************************
    */
    public int getHwChan()
    {
        return hwChan;
    }


   /**
    ***************************************************************************
    **
    **  Gets the map of configured values.
    **
    **  @return  The map of configured values
    **
    ***************************************************************************
    */
    //@BusCommand
    public Map<String, Object> getConfigValues()
    {
        Map<String, Object> map = new LinkedHashMap<>();
        addConfigValues(map);

        return map;
    }


   /**
    ***************************************************************************
    **
    **  Adds to a map of configured values.
    **
    **  @param  map  The map of configured values to be updated
    **
    ***************************************************************************
    */
    public abstract void addConfigValues(Map<String, Object> map);

}
