/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.common.UnaryOpModule;

public class Averager
extends UnaryOpModule {
    private static final long serialVersionUID = -4691173751121943458L;
    private long delayMillis = 1000L;
    long nextSampleTimestamp = 0L;
    double sum;
    int nsamples;
    private double value;
    int sequenceNumber = 0;

    public void setDelayMillis(long delayMillis) {
        this.delayMillis = delayMillis;
        log.info((Object)("Averager delay " + delayMillis), new String[0]);
    }

    public long getDelayMillis() {
        return this.delayMillis;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    protected void reset() {
        long now = System.currentTimeMillis();
        if (this.nextSampleTimestamp == 0L) {
            this.nextSampleTimestamp = now + this.delayMillis;
        } else {
            do {
                this.nextSampleTimestamp += this.delayMillis;
            } while (this.nextSampleTimestamp <= now);
        }
        this.sum = 0.0;
        this.nsamples = 0;
    }

    protected void updateValue(String output) {
        this.value = this.sum / (double)this.nsamples;
        this.reset();
        log.info((Object)(String.valueOf(output) + " average " + this.value), new String[0]);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, output, (Object)this.value));
    }

    @Override
    public Object processInput(String output, String input, Object val, long timeStamp) {
        if (val instanceof Double) {
            if (this.nextSampleTimestamp == 0L) {
                this.reset();
            }
            this.sum += ((Double)val).doubleValue();
            ++this.nsamples;
            if (System.currentTimeMillis() > this.nextSampleTimestamp) {
                this.updateValue(output);
            }
        }
        return null;
    }
}

