package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.subsystem.common.devices.power.distribution.state.PduProperties;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.command.CommandService;

/**
 * 
 *
 * @author onoprien
 */
public class MonitorFilter extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    static public final MonitorFormat FORMAT = new Formatter();
    static private final Pattern pPduOutlet = Pattern.compile("([^/]+)/state(/.+)/([^/]+)/PduOutletState");
    
    private final String agent;
    private final String[] pdus;


// -- Life cycle : -------------------------------------------------------------
    
    public MonitorFilter(String agent, String pdus) {
        this.agent = agent;
        this.pdus = pdus.split(",");
    }
    
    public MonitorFilter(AgentInfo agent) {
        this.agent = agent.getName();
        this.pdus = agent.getAgentProperty(PduProperties.PDU_COMPONENTS,"").split(",");
    }

    
// -- Filtering : --------------------------------------------------------------
    
    @Override
    public String getName() {
        return agent;
    }

    @Override
    public List<String> getAgents() {
        return Collections.singletonList(agent);
    }

    @Override
    public List<String> getOriginChannels() {
        ArrayList<String> selectors = new ArrayList<>();
        for (String pdu : pdus) {
            selectors.add("/"+ pdu +"/");
            selectors.add("/state/"+ pdu +"/");
        }
        return selectors;
    }

    @Override
    public String getOriginPath(String displayPath) {
        return super.getOriginPath(displayPath);
    }

    @Override
    public String getDisplayPath(String originPath) {
        String dp = originPath.replaceFirst(agent +"/", "");
        dp = dp.replaceFirst("state/", "");
        int i = dp.indexOf("/PduOutletState");
        if (i != -1) {
            dp = dp.substring(0, i);
            i = dp.lastIndexOf("/");
            dp = dp.substring(0,i)+"/Outlets"+dp.substring(i);
        }
        return dp;
    }

    @Override
    public List<String> getFields(boolean compact) {
        if (compact) {
            return Arrays.asList(new String[] {MonitorField.VALUE.getKey(), MonitorField.DESCR.getKey()});
        } else {
            return Arrays.asList(new String[] {MonitorField.VALUE.getKey(), 
                MonitorField.UNITS.getKey(),
                MonitorField.LOW_ALARM.getKey(),
                MonitorField.LOW_WARN.getKey(),
                MonitorField.ALERT_LOW.getKey(),
                MonitorField.HIGH_WARN.getKey(),
                MonitorField.HIGH_ALARM.getKey(),
                MonitorField.ALERT_HIGH.getKey(),
                MonitorField.DESCR.getKey()});
        }
    }
    
    
// -- Utilities : --------------------------------------------------------------
    
    static public String[] getPduAndOutletName(String path) {
        Matcher m = pPduOutlet.matcher(path);
        if (m.matches()) {
            return new String[] {m.group(1) + m.group(2), m.group(3)};
        } else {
            return null;
        }
    }
    
    static private class Formatter extends MonitorFormat {
        @Override
        public FormattedValue format(MonitorField field, AgentChannel ch) {
            FormattedValue fv = super.format(field, ch);
            if ("ON".equals(fv.value) || "OFF".equals(fv.value)) {
                if (fv.bgColor == null) {
                    fv.bgColor = fv.value.equals("ON") ? MonitorField.COLOR_GOOD : MonitorField.COLOR_WARN;
                }
                if (fv.toolTip == null) {
                    fv.toolTip = "Click to switch ON/OFF";
                }
                fv.click1 = cell -> {
                    if (cell != null) {
                        List<DisplayChannel> hh = cell.getChannels();
                        if (hh.size() == 1) {
                            AgentChannel channel = hh.get(0).getChannel();
                            if (channel != null) {
                                String[] ss = MonitorFilter.getPduAndOutletName(channel.getPath());
                                if (ss != null) {
                                    String status = channel.get().toString();
                                    boolean on = "ON".equals(status);
                                    status = on ? "OFF" : "ON";
                                    int flip = JOptionPane.showConfirmDialog(Console.getConsole().getWindow(), "<html>Switch the power outlet<br><b>" + ss[1] + "</b> " + status + "?", "Switch PDU outlet " + status, JOptionPane.OK_CANCEL_OPTION);
                                    if (flip == JOptionPane.OK_OPTION) {
                                        CommandService.getService().send(ss[0], (on ? "outletOff" : "forceOutletOn"), ss[1]);
//                                    Console.getConsole().sendCommand(ss[0] + (on ? "/outletOff" : "/forceOutletOn"), ss[1]);
                                    }
                                }
                            }
                        }
                    }
                };
            }
            return fv;
        }

        @Override
        public FormattedValue format(MonitorField field, List<AgentChannel> channels) {
            return channels.size() == 1 ? format(field, channels.get(0)) : super.format(field, channels);
        }

    }

}