/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.focalplane.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.subsystem.common.ui.focalplane.Segment;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.FocalPlaneFilter;

public class DemoFocalPlaneFilter
extends FocalPlaneFilter {
    private final List<String> agents = Arrays.asList("focal-plane");
    private final List<String> groups = Arrays.asList("REBTempMin", "REBTempMax");
    private final List<String> groupFields = Arrays.asList(MonitorField.MIN_VALUE.toString(), MonitorField.MAX_VALUE.toString());
    private final List<String> channelFields = Arrays.asList(MonitorField.VALUE.getKey());
    private final Predicate<String> pathTester = Pattern.compile(".+/Temp\\d{1,2}").asPredicate();

    @Create(category="FocalPlaneFilter", name="Demo", path="Demo/Tony and Stuart", description="Demo filter based on Tony's and Stuarts's templates.")
    public DemoFocalPlaneFilter() {
    }

    public List<String> getAgents() {
        return this.agents;
    }

    public List<String> getDisplayChannels() {
        return this.groups;
    }

    public List<String> getFields(boolean compact) {
        return compact ? this.groupFields : this.channelFields;
    }

    public List<String> getDisplayPaths(AgentChannel channel) {
        boolean accept = this.pathTester.test(channel.getPath());
        if (accept) {
            String prefix = Segment.getPathPrefix(channel);
            return prefix.isEmpty() ? Collections.emptyList() : this.groups.stream().map(g -> prefix + g).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

