/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.swing;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.Format;
import java.text.ParseException;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DocumentFilter;

public class BoxedFormattedTextField
extends JFormattedTextField {
    public BoxedFormattedTextField() {
    }

    public BoxedFormattedTextField(Object value) {
        super(value);
    }

    public BoxedFormattedTextField(Format format) {
        super(format);
    }

    public BoxedFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
    }

    public BoxedFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
    }

    public BoxedFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory, Object currentValue) {
        super(factory, currentValue);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    public final void setFilter(String regex) {
        ((AbstractDocument)this.getDocument()).setDocumentFilter(new Filter(regex));
    }

    public static class Filter
    extends DocumentFilter {
        private final Pattern pattern;

        public Filter(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text == null || this.pattern.matcher(text).matches()) {
                super.replace(fb, offset, length, text, attrs);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (string == null || this.pattern.matcher(string).matches()) {
                super.insertString(fb, offset, string, attr);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public static class CharFilter
    extends DefaultFormatter {
        private final Pattern pattern;

        public CharFilter(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            return text;
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            return value == null ? null : value.toString();
        }

        @Override
        protected DocumentFilter getDocumentFilter() {
            return new DocumentFilter(){

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                    if (text == null || pattern.matcher(text).matches()) {
                        super.replace(fb, offset, length, text, attrs);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                    if (string == null || pattern.matcher(string).matches()) {
                        super.insertString(fb, offset, string, attr);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            };
        }
    }
}

