package org.lsst.ccs.subsystem.common.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.common.data.MonitorTask;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;

/**
 *  Implements the monitor task control panel.
 *
 *  @author Owen Saxton
 */
public class MonitorTaskPanel extends JPanel {

    private final CommandSender sender;
    private final String node;
    private final JPanel taskPanel;
    private int numTasks = 0;
    private MonitorTaskLine[] taskLines = new MonitorTaskLine[0];

    public MonitorTaskPanel(String title, CommandSender sender, String node) {
        this.sender = sender;
        this.node = node;
        taskPanel = title != null && !title.isEmpty() ? UiUtilities.newBorderedPanel(title) : new JPanel();
        add(taskPanel);
    }

    public void initPanel(List<MonitorTask> tasks) {
        for (MonitorTaskLine line : taskLines) {
            taskPanel.remove(line);
        }
        numTasks = tasks.size();
        taskLines = new MonitorTaskLine[numTasks];
        if (numTasks == 0) return;
        int nameLength = 0;
        for (MonitorTask task : tasks) {
            nameLength = Math.max(nameLength, UiUtilities.getLabelSize(task.getName()).width);
        }
        int index = 0;
        for (MonitorTask task : tasks) {
            taskLines[index++] = new MonitorTaskLine(sender, node, nameLength);
        }
        taskPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(0, 0, 0, 0);
        gbm.anchor = GridBagConstraints.NORTH;
        gbm.gridx = 0;
        gbm.gridy = 0;
        for (int j = 0; j < numTasks; j++) {
            gbm.insets.bottom = (j == numTasks - 1) ? 4 : 0;
            taskPanel.add(taskLines[j], gbm);
            gbm.gridy++;
        }
    }

    public void updatePanel(List<MonitorTask> tasks) {
        int index = 0;
        for (MonitorTask task : tasks) {
            taskLines[index++].updatePanel(task);
        }
    }

    public void disablePanel() {
        for (MonitorTaskLine line : taskLines) {
            line.disablePanel();
        }
    } 

    private static final long serialVersionUID = 1L;
}
