package org.lsst.ccs.subsystem.common.ui.focalplane;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;

/**
 * Dialog that takes user input and creates a descriptor for {@link FocalPlaneMapPage}.
 * Allows selecting page title and the number of regions.
 *
 * @author onoprien
 */
public final class FocalPlaneMapPageDialog extends JDialog {

// -- Fields : -----------------------------------------------------------------
    
    private String pageTitle;
    private int rows, columns;
    
    private JTextField titleField;
    private SpinnerNumberModel rowsSpinner, columnsSpinner;

// -- Life cycle : -------------------------------------------------------------
    
    private FocalPlaneMapPageDialog(Component parentComponent, String defaultTitle) {
        super(parentComponent == null ? null : SwingUtilities.getWindowAncestor(parentComponent), "Open new focal plane map page", Dialog.ModalityType.APPLICATION_MODAL);
        
        Box panel = Box.createVerticalBox();
        add(panel, BorderLayout.CENTER);
        panel.setBorder(BorderFactory.createCompoundBorder(
                BorderFactory.createEtchedBorder(EtchedBorder.LOWERED), BorderFactory.createEmptyBorder(Const.VSPACE, Const.HSPACE, Const.VSPACE, Const.HSPACE)));
        
        Box box = Box.createHorizontalBox();
        panel.add(box);
        box.add(new JLabel("Title:"));
        box.add(Box.createRigidArea(Const.HDIM));
        titleField = new JTextField(defaultTitle, 20);
        box.add(titleField);
        box.add(Box.createHorizontalGlue());
        
        panel.add(Box.createRigidArea(Const.VDIM));
        
        box = Box.createHorizontalBox();
        panel.add(box);
        box.add(new JLabel("Rows:"));
        box.add(Box.createRigidArea(Const.HDIM));
        rowsSpinner = new SpinnerNumberModel(1, 1, 16, 1);
        box.add(new Spinner(rowsSpinner));
        box.add(Box.createRigidArea(new Dimension(Const.HSPACE*3, 0)));
        box.add(new JLabel("Columns:"));
        box.add(Box.createRigidArea(Const.HDIM));
        columnsSpinner = new SpinnerNumberModel(1, 1, 8, 1);
        box.add(new Spinner(columnsSpinner));
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(Box.createHorizontalGlue());
        
        panel.add(Box.createVerticalGlue());
        
        box = Box.createHorizontalBox();
        add(box, BorderLayout.SOUTH);
        box.add(Box.createHorizontalGlue());
        JButton okButton = new JButton(" OK ");
        box.add(okButton);
        okButton.addActionListener(e-> {
            pageTitle = titleField.getText();
            rows = rowsSpinner.getNumber().intValue();
            columns = columnsSpinner.getNumber().intValue();
            dispose();
        });
    }

    static public FocalPlaneMapPageDialog show(Component parentComponent, String defaultTitle) {
        if (parentComponent == null) {
            parentComponent = Console.getConsole().getWindow();
        }
        FocalPlaneMapPageDialog dialog = new FocalPlaneMapPageDialog(parentComponent, defaultTitle);
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.setVisible(true);
        return dialog.pageTitle == null ? null : dialog;
    }

    
// -- Getters : ----------------------------------------------------------------

    public String getPageTitle() {
        return pageTitle;
    }

    public int getRows() {
        return rows;
    }
    
    public int getColumns() {
        return columns;
    }
    
    
// -- Local classes : ----------------------------------------------------------
    
    static private class Spinner extends JSpinner {
        public Spinner(SpinnerModel model) {
            super(model);
        }
        @Override
        public Dimension getMaximumSize() {
            return getPreferredSize();
        }
    }
    
}
