package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import org.lsst.ccs.gconsole.base.filter.GenericFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

/**
 * Apc Pdu state channel filter.
 *
 * @author The LSST CCS Team
 */
public class ApcPduStateFilter extends GenericFilter {


    public final static String FIELDS = 
        MonitorField.VALUE.getKey()+","+
        MonitorField.NAME.getKey()+","+
        MonitorField.DESCR.getKey();
    public final static String SS = AgentChannel.MARK_STATE +"/";
    
    public ApcPduStateFilter(String agents, String selector) {
        super("ApcPdu",agents,selector, "", true, FIELDS);
    }

    
    @Override
    public String getDisplayPath(String originPath) {
        originPath = originPath.replace(AgentChannel.MARK_STATE, SS);
        if ( originPath.endsWith("PduOutletState") ) {
            originPath = originPath.replace("/PduOutletState", "");
            int lastSlash = originPath.lastIndexOf("/");
            originPath = originPath.substring(0,lastSlash)+"//outlets/"+originPath.substring(lastSlash);
        } else {
            int lastSlash = originPath.lastIndexOf("/");
            originPath = originPath.substring(0, lastSlash)+"/"+originPath.substring(lastSlash);        
            
        }        
        return originPath;
    }
           
}
