package org.lsst.ccs.subsystem.common.ui.focalplane.fpmap;

import java.awt.Color;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;

/**
 * Data to be displayed in a cell (raft or CCD) on a {@link FocalPlaneMap}.
 *
 * @author onoprien
 */
public class FocalPlaneMapValue extends FormattedValue {

// -- Fields : -----------------------------------------------------------------
    
    /** Empty non-split cell. */
    static public final FocalPlaneMapValue EMPTY = new FocalPlaneMapValue();
    /** Empty split cell. */
    static public final FocalPlaneMapValue EMPTY_SPLIT = new FocalPlaneMapValue(); static {EMPTY_SPLIT.setSplit(true);}
    /** Indicates that there is no data corresponding to this level of granularity. */
    static public final FocalPlaneMapValue NONE = new FocalPlaneMapValue(); static {NONE.setSplit(true);}

// -- Life cycle : -------------------------------------------------------------
    
    public FocalPlaneMapValue() {
        bgColor = Color.DARK_GRAY;
    }
    
// -- Properties : -------------------------------------------------------------
    
    public boolean split;

    public boolean isSplit() {
        return split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public Color getColor() {
        return bgColor;
    }

    public void setColor(Color color) {
        bgColor = color;
    }

}
