/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;

public class MouseAdapterDoubleClick
extends MouseAdapter {
    private int delay = 200;
    private boolean clickedOnce = false;
    private Timer clickTimer;

    @Override
    public final void mouseClicked(MouseEvent e) {
        switch (e.getClickCount()) {
            case 1: {
                if (this.clickedOnce) {
                    this.clickedOnce = false;
                    this.clickTimer.stop();
                    break;
                }
                this.clickedOnce = true;
                this.clickTimer = new Timer(200, evt -> {
                    this.mouseClickedFiltered(e);
                    this.clickedOnce = false;
                    this.clickTimer.stop();
                });
                this.clickTimer.setRepeats(false);
                this.clickTimer.start();
                break;
            }
            default: {
                this.clickedOnce = false;
                this.clickTimer.stop();
                this.mouseClickedFiltered(e);
            }
        }
    }

    public void mouseClickedFiltered(MouseEvent e) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Click Action Example");
        frame.setDefaultCloseOperation(3);
        JLabel label = new JLabel("Click me!");
        label.addMouseListener(new MouseAdapterDoubleClick(){

            @Override
            public void mouseClickedFiltered(MouseEvent e) {
                System.out.println("Filtered " + e.getClickCount());
            }
        });
        frame.getContentPane().add(label);
        frame.pack();
        frame.setVisible(true);
    }
}

