/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.console;

import java.awt.Component;
import java.awt.Point;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsolePlugin;
import org.freehep.jas.plugin.console.ConsolePropertiesPanel;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;

class StudioConsole
extends Console
implements HasPopupItems,
PageListener {
    private Application app;
    private ConsolePlugin plugin;
    private CommandProcessor commands = new Commands();
    private boolean selected = false;
    private final HasPopupItems morePopupItems;

    StudioConsole(Application app, ConsolePlugin plugin, HasPopupItems morePopupItems) {
        this.app = app;
        this.plugin = plugin;
        this.morePopupItems = morePopupItems;
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        this.app.getXMLMenuBuilder().mergePopupMenu("consolePopupMenu", menu);
        if (this.morePopupItems != null) {
            this.morePopupItems.modifyPopupMenu(menu, source, p);
        }
        return menu;
    }

    void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.app.getCommandTargetManager().add((CommandGroup)this.commands);
        } else {
            this.app.getCommandTargetManager().remove((CommandGroup)this.commands);
        }
    }

    @Override
    public void pageChanged(PageEvent e) {
        if (e.getID() == 3999) {
            this.setSelected(true);
        } else if (e.getID() == 4000) {
            this.setSelected(false);
        } else if (e.getID() == 4001) {
            this.plugin.consoleIsClosed(this);
            this.dispose();
        }
    }

    @Override
    public void close() {
        this.plugin.closeMe(this);
    }

    @Override
    protected void autoShow() {
        if (!this.selected) {
            this.plugin.showMe(this);
        }
    }

    class Commands
    extends CommandProcessor {
        private PrintWriter pw;

        Commands() {
        }

        public void enableClear(CommandState state) {
            state.setEnabled(StudioConsole.this.getDocument().getLength() > 0);
        }

        public void enableCloseLogFile(CommandState state) {
            state.setEnabled(this.pw != null);
        }

        public void enableCopyConsoleSelection(CommandState state) {
            state.setEnabled(StudioConsole.this.getSelectedText() != null);
        }

        public void enableEnableLogging(BooleanCommandState state) {
            state.setSelected(StudioConsole.this.isLoggingEnabled());
            state.setEnabled(this.pw != null);
        }

        public void enableOpenLogFile(CommandState state) {
            state.setEnabled(this.pw == null);
        }

        public void enableSelectAll(CommandState state) {
            state.setEnabled(StudioConsole.this.getDocument().getLength() > 0);
        }

        public void onClear() {
            StudioConsole.this.clear();
            this.setChanged();
        }

        public void onCloseLogFile() {
            StudioConsole.this.setLogStream(null);
            this.pw.println("Log file closed on " + new Date());
            this.pw.close();
            this.pw = null;
            this.setChanged();
        }

        public void onCopyConsoleSelection() {
            StudioConsole.this.copy();
        }

        public void onEnableLogging(boolean enabled) {
            if (enabled) {
                this.pw.println("Logging resumed at " + new Date());
            }
            StudioConsole.this.setLoggingEnabled(enabled);
            if (!enabled) {
                this.pw.println("Logging paused at " + new Date());
            }
            this.setChanged();
        }

        public void onOpenLogFile() {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Open or Create Log File...");
            int returnVal = chooser.showOpenDialog(StudioConsole.this);
            if (returnVal == 0) {
                int rc;
                File f = chooser.getSelectedFile();
                if (f.exists() && (rc = JOptionPane.showConfirmDialog(StudioConsole.this, "Replace existing file?", null, 2)) != 0) {
                    return;
                }
                try {
                    BufferedOutputStream logOutput = new BufferedOutputStream(new FileOutputStream(f));
                    this.pw = new PrintWriter(new OutputStreamWriter(logOutput));
                    this.pw.println("Log file created on " + new Date());
                    this.pw.flush();
                    StudioConsole.this.setLogStream(logOutput);
                    this.setChanged();
                }
                catch (IOException eh) {
                    StudioConsole.this.app.error("Couldn't open file" + f.getName(), eh);
                }
            }
        }

        public void onSelectAll() {
            StudioConsole.this.selectAll();
            this.setChanged();
        }

        public void onProperties() {
            ConsolePropertiesPanel cpp = new ConsolePropertiesPanel();
            cpp.setMaxScrollback(StudioConsole.this.getMaxScrollback());
            cpp.setAutoShow(StudioConsole.this.getAutoShow());
            String title = StudioConsole.this.plugin.getPageContextForConsole(StudioConsole.this).getTitle();
            int rc = JOptionPane.showOptionDialog(StudioConsole.this.app, cpp, title + " properties", 2, -1, null, null, null);
            if (rc == 0) {
                StudioConsole.this.setMaxScrollback(cpp.getMaxScrollback());
                StudioConsole.this.setAutoShow(cpp.getAutoShow());
            }
        }
    }
}

