/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Properties;
import org.freehep.graphicsio.ImageGraphics2D;

class ImageBytes {
    private String format;
    private byte[] bytes;

    public ImageBytes(RenderedImage image, Color bkg, String format, String colorModel) throws IOException {
        if ("ZLIB".equals(format) || image.getColorModel().hasAlpha() && bkg == null) {
            this.bytes = this.toZLIB(image, bkg, colorModel);
            this.format = "ZLIB";
        } else if ("JPEG".equals(format)) {
            this.bytes = this.toJPG(image);
            this.format = "JPG";
        } else {
            byte[] zlibBytes;
            byte[] jpgBytes = this.toJPG(image);
            if ((double)jpgBytes.length < 0.5 * (double)(zlibBytes = this.toZLIB(image, bkg, colorModel)).length) {
                this.bytes = jpgBytes;
                this.format = "JPG";
            } else {
                this.bytes = zlibBytes;
                this.format = "ZLIB";
            }
        }
    }

    private byte[] toZLIB(RenderedImage image, Color bkg, String colorModel) throws IOException {
        return ImageGraphics2D.toByteArray((RenderedImage)image, (String)"RAW", (String)"Flate-ASCII85", (Properties)ImageGraphics2D.getRAWProperties((Color)bkg, (String)colorModel));
    }

    private byte[] toJPG(RenderedImage image) throws IOException {
        return ImageGraphics2D.toByteArray((RenderedImage)image, (String)"JPG", (String)"ASCII85", null);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getFormat() {
        return this.format;
    }
}

