/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.hibernate.SessionFactory;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.CacheStatistics;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.InfluxDbClientService;
import org.lsst.ccs.startup.HasCommandLineOptions;

public class StatusPersisterSubsystem
extends Subsystem
implements HasCommandLineOptions,
HasLifecycle {
    private static SessionFactory fac;
    private final Properties p = new Properties();
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    StatusDataPersister statusDataPersister;
    @LookupField(strategy=LookupField.Strategy.TREE)
    InfluxDbClientService influxDbClientService;
    private final Options commandLineOptions = new Options();

    public StatusPersisterSubsystem() {
        super("localdb", AgentInfo.AgentType.SERVICE);
        Properties inProps = BootstrapResourceUtils.getBootstrapSystemProperties();
        if (inProps != null) {
            this.p.putAll((Map<?, ?>)inProps);
        }
        this.commandLineOptions.addOption("u", "update", false, "Start the Trending Ingest Module in update mode.");
    }

    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("statistics-publish", () -> {
            if (this.influxDbClientService != null) {
                CacheStatistics cacheStatistics = new CacheStatistics(fac, this.influxDbClientService);
            }
        }).withIsFixedRate(true).withPeriod(Duration.ofMinutes(1L)));
    }

    public void init() {
        fac = StatusdbUtils.getSessionFactory((Properties)this.p);
    }

    public void processCommandLineOptions(String[] args) throws ParseException {
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(this.commandLineOptions, args, true);
            if (line.hasOption("update")) {
                this.p.setProperty("hibernate.hbm2ddl.auto", "update");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printHelp();
        }
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "localdb", "", this.commandLineOptions, "", true);
    }

    public SessionFactory getSessionFactory() {
        return fac;
    }
}

