package org.lsst.ccs.subsystem.common.ui.focalplane.filter;

import java.util.*;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.subsystem.common.ui.focalplane.Segment;

/**
 * Demo filter based on Tony's and Stuarts's templates.\
 * <p>
 * See {@link FocalPlaneFilter} for the description of requirements to filters used with focal plane views.
 *
 * @author onoprien
 */
public class DemoFocalPlaneFilter extends FocalPlaneFilter {

// -- Fields : -----------------------------------------------------------------
    
    private final List<String> agents = Arrays.asList(new String[] {"focal-plane"});
    private final List<String> groups = Arrays.asList(new String[] {"REBTempMin", "REBTempMax"});
    private final List<String> groupFields = Arrays.asList(new String[] {MonitorField.MIN_VALUE.toString(), MonitorField.MAX_VALUE.toString()});
    private final List<String> channelFields = Arrays.asList(new String[] {MonitorField.VALUE.getKey()});
    
    private final Predicate<String> pathTester = Pattern.compile(".+/Temp\\d{1,2}").asPredicate();

// -- Life cycle : -------------------------------------------------------------

    @Create(category = CATEGORY,
            name = "Demo",
            path = "Demo/Tony and Stuart",
            description = "Demo filter based on Tony's and Stuarts's templates.")
    public DemoFocalPlaneFilter() {
    }
    
// -- Implement FocalPlaneFilter : ---------------------------------------------

    @Override
    public List<String> getAgents() {
        return agents;
    }

    @Override
    public List<String> getDisplayChannels() {
        return groups;
    }

    @Override
    public List<String> getFields(boolean compact) {
        return compact ? groupFields : channelFields;
    }

    @Override
    public List<String> getDisplayPaths(AgentChannel channel) {
        boolean accept = pathTester.test(channel.getPath());
        if (accept) {
            String prefix = Segment.getPathPrefix(channel);
            return prefix.isEmpty() ? Collections.emptyList() : groups.stream().map(g -> prefix + g).collect(Collectors.toList());
        } else {
            return Collections.emptyList();
        }
    }
    
}
