/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import org.freehep.jas.extension.editor.SimpleEditor;

public class FontPropertyDialog
extends JPanel {
    private String currentText;
    private String currentFontSize;
    private String currentFontType;
    private String currentFontStyle;
    private Color currentColor;
    private SimpleEditor plugin;
    private JButton chooseColorButton;
    private JLabel colorLabel;
    private JPanel colorPanel;
    private JLabel colorSample;
    private JLabel fontLabel;
    private JPanel fontPanel;
    private JComboBox fontsComboBox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JComboBox sizeComboBox;
    private JLabel sizeLabel;
    private JPanel sizePanel1;
    private JComboBox styleComboBox;
    private JLabel styleLabel;
    private JPanel stylePanel;
    private JComboBox textComboBox;
    private JPanel textFieldsPanel;
    private JLabel textLabel;

    public FontPropertyDialog(SimpleEditor plugin, String[] textFields) {
        this.plugin = plugin;
        this.initComponents();
        this.textComboBox.setModel(new DefaultComboBoxModel<String>(textFields));
        this.setCurrentFields();
    }

    private void initComponents() {
        this.textFieldsPanel = new JPanel();
        this.textLabel = new JLabel();
        this.jPanel6 = new JPanel();
        this.jPanel1 = new JPanel();
        this.fontPanel = new JPanel();
        this.fontLabel = new JLabel();
        this.sizePanel1 = new JPanel();
        this.sizeLabel = new JLabel();
        this.stylePanel = new JPanel();
        this.styleLabel = new JLabel();
        this.colorPanel = new JPanel();
        this.colorLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.fontsComboBox = new JComboBox();
        this.jPanel3 = new JPanel();
        this.sizeComboBox = new JComboBox();
        this.jPanel4 = new JPanel();
        this.styleComboBox = new JComboBox();
        this.jPanel5 = new JPanel();
        this.chooseColorButton = new JButton();
        this.colorSample = new JLabel();
        this.textComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.textFieldsPanel.setLayout(new GridBagLayout());
        this.textFieldsPanel.setBorder(new BevelBorder(0));
        this.textLabel.setText("Select Text");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 0, 6);
        this.textFieldsPanel.add((Component)this.textLabel, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                FontPropertyDialog.this.jPanel1MouseEntered(evt);
            }
        });
        this.fontPanel.setLayout(new GridBagLayout());
        this.fontPanel.setMinimumSize(new Dimension(31, 41));
        this.fontPanel.setPreferredSize(new Dimension(35, 25));
        this.fontLabel.setText("Font");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.fontPanel.add((Component)this.fontLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.fontPanel, gridBagConstraints);
        this.sizePanel1.setLayout(new GridBagLayout());
        this.sizePanel1.setPreferredSize(new Dimension(35, 25));
        this.sizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.sizePanel1.add((Component)this.sizeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.sizePanel1, gridBagConstraints);
        this.stylePanel.setLayout(new GridBagLayout());
        this.stylePanel.setMinimumSize(new Dimension(135, 41));
        this.stylePanel.setPreferredSize(new Dimension(35, 25));
        this.styleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.stylePanel.add((Component)this.styleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.stylePanel, gridBagConstraints);
        this.colorPanel.setLayout(new GridBagLayout());
        this.colorPanel.setPreferredSize(new Dimension(35, 25));
        this.colorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.colorPanel.add((Component)this.colorLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.colorPanel, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.getAvailableFonts();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel2.add((Component)this.fontsComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.sizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"8", "10", "12", "14", "16", "18", "20"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel3.add((Component)this.sizeComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.styleComboBox.setMaximumRowCount(4);
        this.styleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Plain", "Bold", "Italic", "Bold & Italic"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel4.add((Component)this.styleComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel5.setBorder(new EtchedBorder());
        this.chooseColorButton.setText("...");
        this.chooseColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontPropertyDialog.this.chooseColorButtonActionPerformed(evt);
            }
        });
        this.chooseColorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                FontPropertyDialog.this.chooseColorButtonMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel5.add((Component)this.chooseColorButton, gridBagConstraints);
        this.colorSample.setText("ccc");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel5.add((Component)this.colorSample, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel6.add((Component)this.jPanel1, gridBagConstraints);
        this.textComboBox.setMaximumRowCount(3);
        this.textComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontPropertyDialog.this.textComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel6.add((Component)this.textComboBox, gridBagConstraints);
        this.textFieldsPanel.add((Component)this.jPanel6, new GridBagConstraints());
        this.add((Component)this.textFieldsPanel, new GridBagConstraints());
    }

    private void chooseColorButtonActionPerformed(ActionEvent evt) {
    }

    private void chooseColorButtonMousePressed(MouseEvent evt) {
        ColorChooser cc = new ColorChooser(this);
        cc.setLocationRelativeTo(this);
        cc.setVisible(true);
    }

    private void textComboBoxActionPerformed(ActionEvent evt) {
        this.setCurrentFields();
    }

    private void jPanel1MouseEntered(MouseEvent evt) {
        this.textComboBox.hidePopup();
        this.fontsComboBox.hidePopup();
        this.sizeComboBox.hidePopup();
        this.styleComboBox.hidePopup();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    private void getAvailableFonts() {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envfonts = gEnv.getAvailableFontFamilyNames();
        this.fontsComboBox.setModel(new DefaultComboBoxModel<String>(envfonts));
    }

    public void apply() {
        this.plugin.setFontSize(this.currentText, (String)this.sizeComboBox.getSelectedItem());
        this.plugin.setFontType(this.currentText, (String)this.fontsComboBox.getSelectedItem());
        this.plugin.setFontStyle(this.currentText, (String)this.styleComboBox.getSelectedItem());
        this.plugin.setColor(this.currentText, this.currentColor);
    }

    private void setCurrentFields() {
        this.currentText = (String)this.textComboBox.getSelectedItem();
        this.currentFontSize = this.plugin.getFontSize(this.currentText);
        this.currentFontType = this.plugin.getFontType(this.currentText);
        this.currentFontStyle = this.plugin.getFontStyle(this.currentText);
        this.setColor(this.plugin.getFontColor(this.currentText));
        this.fontsComboBox.setSelectedItem(this.currentFontType);
        this.sizeComboBox.setSelectedItem(this.currentFontSize);
        this.styleComboBox.setSelectedItem(this.currentFontStyle);
    }

    private void setColor(Color color) {
        this.jPanel5.setForeground(color);
        this.jPanel5.setBackground(color);
        this.colorSample.setForeground(color);
        this.colorSample.setBackground(color);
        this.currentColor = color;
    }

    private class ColorChooser
    extends JDialog {
        private JPanel buttonPanel;
        private JButton okButton;
        private JButton applyButton;
        private JButton cancelButton;
        private FontPropertyDialog dialog;
        private JColorChooser cc;

        ColorChooser(FontPropertyDialog dialog) {
            super((Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, dialog), true);
            this.buttonPanel = new JPanel();
            this.okButton = new JButton("OK");
            this.applyButton = new JButton("Apply");
            this.cancelButton = new JButton("Cancel");
            this.setTitle("Color Chooser");
            this.dialog = dialog;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.cc = new JColorChooser();
            this.getContentPane().setLayout(new GridBagLayout());
            this.cc.setVisible(true);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.getContentPane().add((Component)this.cc, gridBagConstraints);
            this.okButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ColorChooser.this.setColor();
                    ColorChooser.this.close();
                }
            });
            this.applyButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ColorChooser.this.setColor();
                }
            });
            this.cancelButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ColorChooser.this.close();
                }
            });
            this.buttonPanel.setLayout(new GridBagLayout());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.buttonPanel.add((Component)this.applyButton, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
            this.pack();
        }

        public void close() {
            this.setVisible(false);
            this.dispose();
        }

        public void setColor() {
            this.dialog.setColor(this.cc.getColor());
        }
    }
}

