/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.Arrays;
import java.util.BitSet;
import org.h2.engine.Database;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.db.MVTempResult;
import org.h2.mvstore.db.ValueDataType;
import org.h2.mvstore.type.DataType;
import org.h2.result.ResultExternal;
import org.h2.result.SortOrder;
import org.h2.value.Value;
import org.h2.value.ValueRow;

class MVSortedTempResult
extends MVTempResult {
    private final boolean distinct;
    private final int[] distinctIndexes;
    private final int[] indexes;
    private final MVMap<ValueRow, Long> map;
    private MVMap<ValueRow, Object> index;
    private ValueDataType orderedDistinctOnType;
    private Cursor<ValueRow, Long> cursor;
    private Value[] current;
    private long valueCount;

    private MVSortedTempResult(MVSortedTempResult mVSortedTempResult) {
        super(mVSortedTempResult);
        this.distinct = mVSortedTempResult.distinct;
        this.distinctIndexes = mVSortedTempResult.distinctIndexes;
        this.indexes = mVSortedTempResult.indexes;
        this.map = mVSortedTempResult.map;
        this.rowCount = mVSortedTempResult.rowCount;
    }

    MVSortedTempResult(Database database, Expression[] expressionArray, boolean bl, int[] nArray, int n, int n2, SortOrder sortOrder) {
        Object object;
        int[] nArray2;
        int[] nArray3;
        block9: {
            super(database, expressionArray, n, n2);
            this.distinct = bl;
            this.distinctIndexes = nArray;
            nArray3 = new int[n2];
            if (sortOrder != null) {
                int n3;
                int n4;
                nArray2 = new int[n2];
                object = sortOrder.getQueryColumnIndexes();
                int n5 = ((int[])object).length;
                BitSet bitSet = new BitSet();
                for (n4 = 0; n4 < n5; ++n4) {
                    n3 = object[n4];
                    assert (!bitSet.get(n3));
                    bitSet.set(n3);
                    nArray2[n4] = n3;
                    nArray3[n4] = sortOrder.getSortTypes()[n4];
                }
                n4 = 0;
                for (n3 = n5; n3 < n2; ++n3) {
                    n4 = bitSet.nextClearBit(n4);
                    nArray2[n3] = n4++;
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    if (nArray2[n3] == n3) {
                        continue;
                    }
                    break block9;
                }
                nArray2 = null;
            } else {
                nArray2 = null;
            }
        }
        this.indexes = nArray2;
        object = new ValueDataType(database, nArray3);
        MVMap.BasicBuilder basicBuilder = new MVMap.Builder().keyType((DataType)object);
        this.map = this.store.openMap("tmp", basicBuilder);
        if (bl && n2 != n || nArray != null) {
            int n6 = nArray != null ? nArray.length : n;
            ValueDataType valueDataType = new ValueDataType(database, new int[n6]);
            MVMap.BasicBuilder basicBuilder2 = new MVMap.Builder().keyType(valueDataType);
            if (nArray != null && sortOrder != null) {
                ((MVMap.Builder)basicBuilder2).valueType((DataType)object);
                this.orderedDistinctOnType = object;
            }
            this.index = this.store.openMap("idx", basicBuilder2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int addRow(Value[] valueArray) {
        assert (this.parent == null);
        ValueRow valueRow = this.getKey(valueArray);
        if (this.distinct || this.distinctIndexes != null) {
            ValueRow valueRow2;
            if (this.distinctIndexes != null) {
                int n = this.distinctIndexes.length;
                Value[] valueArray2 = new Value[n];
                for (int i = 0; i < n; ++i) {
                    valueArray2[i] = valueArray[this.distinctIndexes[i]];
                }
                ValueRow valueRow3 = ValueRow.get(valueArray2);
                if (this.orderedDistinctOnType == null) {
                    if (this.index.putIfAbsent(valueRow3, true) != null) {
                        return this.rowCount;
                    }
                } else {
                    ValueRow valueRow4 = (ValueRow)this.index.get(valueRow3);
                    if (valueRow4 == null) {
                        this.index.put(valueRow3, valueRow);
                    } else {
                        if (this.orderedDistinctOnType.compare(valueRow4, valueRow) <= 0) return this.rowCount;
                        this.map.remove(valueRow4);
                        --this.rowCount;
                        this.index.put(valueRow3, valueRow);
                    }
                }
            } else if (this.visibleColumnCount != this.resultColumnCount && this.index.putIfAbsent(valueRow2 = ValueRow.get(Arrays.copyOf(valueArray, this.visibleColumnCount)), true) != null) {
                return this.rowCount;
            }
            if (this.map.putIfAbsent(valueRow, 1L) != null) return this.rowCount;
            ++this.rowCount;
            return this.rowCount;
        } else {
            Long l = this.map.putIfAbsent(valueRow, 1L);
            if (l != null) {
                this.map.put(valueRow, l + 1L);
            }
            ++this.rowCount;
        }
        return this.rowCount;
    }

    @Override
    public boolean contains(Value[] valueArray) {
        if (this.parent != null) {
            return this.parent.contains(valueArray);
        }
        assert (this.distinct);
        if (this.visibleColumnCount != this.resultColumnCount) {
            return this.index.containsKey(ValueRow.get(valueArray));
        }
        return this.map.containsKey(this.getKey(valueArray));
    }

    @Override
    public synchronized ResultExternal createShallowCopy() {
        if (this.parent != null) {
            return this.parent.createShallowCopy();
        }
        if (this.closed) {
            return null;
        }
        ++this.childCount;
        return new MVSortedTempResult(this);
    }

    private ValueRow getKey(Value[] valueArray) {
        if (this.indexes != null) {
            Value[] valueArray2 = new Value[this.indexes.length];
            for (int i = 0; i < this.indexes.length; ++i) {
                valueArray2[i] = valueArray[this.indexes[i]];
            }
            valueArray = valueArray2;
        }
        return ValueRow.get(valueArray);
    }

    private Value[] getValue(Value[] valueArray) {
        if (this.indexes != null) {
            Value[] valueArray2 = new Value[this.indexes.length];
            for (int i = 0; i < this.indexes.length; ++i) {
                valueArray2[this.indexes[i]] = valueArray[i];
            }
            valueArray = valueArray2;
        }
        return valueArray;
    }

    @Override
    public Value[] next() {
        if (this.cursor == null) {
            this.cursor = this.map.cursor(null);
            this.current = null;
            this.valueCount = 0L;
        }
        if (--this.valueCount > 0L) {
            return this.current;
        }
        if (!this.cursor.hasNext()) {
            this.current = null;
            return null;
        }
        this.current = this.getValue(this.cursor.next().getList());
        if (this.hasEnum) {
            this.fixEnum(this.current);
        }
        this.valueCount = this.cursor.getValue();
        return this.current;
    }

    @Override
    public int removeRow(Value[] valueArray) {
        assert (this.parent == null && this.distinct);
        if (this.visibleColumnCount != this.resultColumnCount) {
            throw DbException.getUnsupportedException("removeRow()");
        }
        if (this.map.remove(this.getKey(valueArray)) != null) {
            --this.rowCount;
        }
        return this.rowCount;
    }

    @Override
    public void reset() {
        this.cursor = null;
        this.current = null;
        this.valueCount = 0L;
    }
}

