/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Color;
import java.math.BigInteger;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public class MonitorField {
    public static final Color COLOR_FG = Color.BLACK;
    public static final Color COLOR_BG = Color.WHITE;
    public static final Color COLOR_CHANGED = Color.BLUE;
    public static final Color COLOR_GOOD = new Color(160, 255, 160);
    public static final Color COLOR_WARN = new Color(255, 255, 100);
    public static final Color COLOR_ERR = new Color(255, 160, 160);
    public static final Color COLOR_DISABLED = new Color(255, 200, 255);
    public static final Color COLOR_OFF = new Color(160, 200, 255);
    public static final Color COLOR_POPUP = new Color(255, 255, 160);
    public static final Color COLOR_MULTI = Color.LIGHT_GRAY;
    public static final Color COLOR_NA = COLOR_BG;
    public static final EnumMap<DataProviderState, Color> COLOR_STATE = new EnumMap(DataProviderState.class);
    public static final String TEXT_MULTI = "---";
    public static final int HA_MULTI = 0;
    private static final HashMap<String, MonitorField> fields;
    private static final Pattern CORE_STATE_PATTERN;
    private static final Pattern FORMAT_CONVERSION_PATTERN;
    public static final MonitorField NULL;
    public static final MonitorField NAME;
    public static final MonitorField VALUE;
    public static final MonitorField UNITS;
    public static final MonitorField LOW_ALARM;
    public static final MonitorField LOW_WARN;
    public static final MonitorField ALERT_LOW;
    public static final MonitorField HIGH_ALARM;
    public static final MonitorField HIGH_WARN;
    public static final MonitorField ALERT_HIGH;
    public static final MonitorField DESCR;
    public static final MonitorField AVERAGE_VALUE;
    public static final MonitorField MAX_VALUE;
    public static final MonitorField MIN_VALUE;
    public static final MonitorField MEDIAN_VALUE;
    public static final MonitorField HOST;
    public static final MonitorField DEFAULT_GROUP_FIELD;
    public static final MonitorField[] GROUP_FIELDS;
    protected String DEFAULT_FLOAT_FORMAT = "%14.5f";
    protected String DEFAULT_INT_FORMAT = "%10d";
    protected String DEFAULT_DT_FORMAT = "%1$tF %1$tT";
    protected int LENGTH_LIMIT = 40;
    protected final String key;
    protected final String title;
    protected final FormattedValue template;
    protected final Set<String> keys;

    public MonitorField(String key, String title, FormattedValue template, Set<String> keys) {
        this.key = key;
        this.title = title;
        FormattedValue formattedValue = this.template = template == null ? new FormattedValue() : new FormattedValue(template);
        this.keys = keys == null ? (key == null ? Collections.emptySet() : Collections.singleton(key)) : keys;
    }

    public MonitorField(String key, String title, FormattedValue template) {
        this(key, title, template, null);
    }

    public MonitorField(MonitorField other) {
        this.key = other.key;
        this.title = other.title;
        this.template = other.template;
        this.keys = other.keys;
    }

    public static synchronized void registerInstance(MonitorField field) {
        String key = field.getKey();
        if (fields.containsKey(key)) {
            throw new IllegalArgumentException("Field with key " + key + " is already registered.");
        }
        fields.put(key, field);
    }

    public static synchronized MonitorField getInstance(String key) {
        MonitorField field = MonitorField.getRegisteredInstance(key);
        if (field == null) {
            try {
                if (key.startsWith("MonitorField.")) {
                    key = key.substring("MonitorField.".length());
                }
                field = (MonitorField)MonitorField.class.getField(key).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NullPointerException | SecurityException exception) {
                // empty catch block
            }
        }
        if (field == null) {
            field = new MonitorField(key, key, null);
            MonitorField.registerInstance(field);
        }
        return field;
    }

    public static synchronized MonitorField getRegisteredInstance(String key) {
        return fields.get(key);
    }

    public static synchronized List<MonitorField> getDefaultFields(Collection<String> keys) {
        return keys.stream().map(k -> MonitorField.getRegisteredInstance(k)).filter(f -> f != null).collect(Collectors.toList());
    }

    public static List<MonitorField> getAffectedFields(Collection<String> keys, Collection<MonitorField> fields) {
        if (keys == null) {
            return null;
        }
        return fields.stream().filter(field -> {
            Set<String> att = field.getKeys();
            return keys.stream().anyMatch(k -> att.contains(k));
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MonitorField> getAffectedFields(Collection<String> keys) {
        if (keys == null) {
            return null;
        }
        Class<MonitorField> clazz = MonitorField.class;
        synchronized (MonitorField.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MonitorField.getAffectedFields(keys, fields.values());
        }
    }

    public Object getValue(AgentChannel channel) {
        return channel == null || this.key == null ? null : channel.get(this.key);
    }

    public String getKey() {
        return this.key;
    }

    public String getTitle() {
        return this.title;
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public boolean isUpdatable() {
        return !this.getKeys().isEmpty();
    }

    public FormattedValue format(AgentChannel channel) {
        FormattedValue fv = new FormattedValue(this.template);
        fv = this.defaultFormat(channel, fv);
        return fv;
    }

    public FormattedValue format(List<AgentChannel> channels) {
        List<FormattedValue> fvList = channels.stream().map(ch -> this.format((AgentChannel)ch)).collect(Collectors.toList());
        FormattedValue fv = this.merge(fvList);
        return fv;
    }

    protected FormattedValue defaultFormat(AgentChannel channel, FormattedValue fv) {
        if (channel == null) {
            return FormattedValue.NA;
        }
        if (fv.value == null) {
            fv.value = this.getValue(channel);
            if (fv.value == null) {
                return FormattedValue.NA;
            }
        }
        if (channel.getAgent().hasAgentProperty("agentOffline") && this.keys.contains(AgentChannel.Key.STATE)) {
            fv.bgColor = COLOR_OFF;
        }
        if (fv.value instanceof ConfigurationParameterInfo) {
            this.colorConfigurationParameter(fv, channel);
        }
        this.colorByChannelState(fv, channel);
        if (fv.text == null) {
            if (fv.format != null) {
                char conv = MonitorField.getFormatConversion(fv.format).charAt(0);
                try {
                    switch (conv) {
                        case 'X': 
                        case 'd': 
                        case 'o': 
                        case 'x': {
                            if (fv.value instanceof Integer || fv.value instanceof Long || fv.value instanceof Short || fv.value instanceof Byte || fv.value instanceof BigInteger) break;
                            fv.value = Long.parseLong(fv.value.toString());
                            break;
                        }
                        case 'E': 
                        case 'G': 
                        case 'e': 
                        case 'f': 
                        case 'g': {
                            if (fv.value instanceof Double || fv.value instanceof Float || fv.value instanceof BigInteger) break;
                            fv.value = Double.parseDouble(fv.value.toString());
                        }
                    }
                    fv.text = String.format(fv.format, fv.value);
                }
                catch (NumberFormatException | IllegalFormatException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (fv.text == null) {
                if (fv.value instanceof Double || fv.value instanceof Float) {
                    try {
                        fv.text = String.format(this.DEFAULT_FLOAT_FORMAT, fv.value);
                    }
                    catch (IllegalFormatException illegalFormatException) {}
                } else if (fv.value instanceof Integer) {
                    try {
                        fv.text = String.format(this.DEFAULT_INT_FORMAT, fv.value);
                    }
                    catch (IllegalFormatException illegalFormatException) {}
                } else if (fv.value instanceof Instant) {
                    try {
                        fv.text = String.format(this.DEFAULT_DT_FORMAT, ZonedDateTime.ofInstant((Instant)fv.value, ZoneId.systemDefault()));
                    }
                    catch (DateTimeException | IllegalFormatException runtimeException) {}
                } else if (fv.value instanceof ZonedDateTime) {
                    try {
                        fv.text = String.format(this.DEFAULT_DT_FORMAT, fv.value);
                    }
                    catch (IllegalFormatException illegalFormatException) {
                        // empty catch block
                    }
                }
            }
            if (fv.text == null) {
                fv.text = fv.value.toString();
            }
            if (fv.text.length() > this.LENGTH_LIMIT) {
                fv.toolTip = fv.toolTip == null ? fv.text : "<html><b>" + fv.text + "</b><br>" + fv.toolTip;
            }
        }
        return fv;
    }

    public FormattedValue colorConfigurationParameter(FormattedValue fv, AgentChannel channel) {
        ConfigurationParameterInfo conf = (ConfigurationParameterInfo)fv.value;
        fv.value = conf.getCurrentValue();
        if (fv.editable == null) {
            fv.editable = !conf.isFinal() && !conf.isReadOnly() && !conf.isBuild();
        }
        if (fv.toolTip == null) {
            if (fv.editable.booleanValue()) {
                fv.toolTip = conf.getDescription();
                if (fv.bgColor == null && !channel.getAgent().hasAgentProperty("agentOffline")) {
                    fv.bgColor = conf.isDirty() ? COLOR_WARN : COLOR_GOOD;
                }
            } else {
                fv.toolTip = conf.getDescription() + " (" + (conf.isReadOnly() ? "READ-ONLY" : (conf.isBuild() ? "BUILD" : "FINAL")) + ")";
            }
        }
        return fv;
    }

    public FormattedValue colorByChannelState(FormattedValue fv, AgentChannel channel) {
        if (fv.bgColor == null && this.keys.contains(AgentChannel.Key.STATE)) {
            if (channel.getAgent().hasAgentProperty("agentOffline")) {
                fv.bgColor = COLOR_OFF;
            } else {
                DataProviderState state = (DataProviderState)channel.get(AgentChannel.Key.STATE);
                if (state != null) {
                    fv.bgColor = COLOR_STATE.get(state);
                }
            }
        }
        return fv;
    }

    public FormattedValue merge(List<FormattedValue> values) {
        switch (values.size()) {
            case 0: {
                return new FormattedValue(this.getTitle(), COLOR_FG, COLOR_BG, 0, null, false);
            }
            case 1: {
                return values.get(0);
            }
        }
        Iterator<FormattedValue> it = values.iterator();
        FormattedValue first = it.next();
        String text = first.getText();
        Color fgColor = first.getFgColor();
        Color bgColor = first.getBgColor();
        int horizontalAlignment = first.getHorizontalAlignment();
        String toolTip = first.getToolTip();
        while (it.hasNext()) {
            FormattedValue other = it.next();
            if (!Objects.equals(text, other.getText())) {
                text = TEXT_MULTI;
            }
            fgColor = this.mergeConfigColor(fgColor, other.getFgColor());
            bgColor = this.mergeStateColor(bgColor, other.getBgColor());
            if (horizontalAlignment != other.getHorizontalAlignment()) {
                horizontalAlignment = 0;
            }
            if (Objects.equals(toolTip, other.getToolTip())) continue;
            toolTip = null;
        }
        return new FormattedValue(text, fgColor, bgColor, horizontalAlignment, toolTip, false);
    }

    public Color mergeConfigColor(Color c1, Color c2) {
        return COLOR_FG.equals(c1) ? c2 : c1;
    }

    public Color mergeStateColor(Color c1, Color c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        for (Color c : COLOR_STATE.values()) {
            if (c.equals(c1)) {
                return c2;
            }
            if (!c.equals(c2)) continue;
            return c1;
        }
        return c1;
    }

    private static String getFormatConversion(String format) {
        String[] ss;
        for (String s : ss = format.split("%")) {
            Matcher m = FORMAT_CONVERSION_PATTERN.matcher(s);
            if (!m.matches()) continue;
            return m.group(1);
        }
        return " ";
    }

    public String toString() {
        return this.title;
    }

    public static MonitorField stringToField(String field) {
        for (MonitorField mf : GROUP_FIELDS) {
            if (!mf.toString().equals(field)) continue;
            return mf;
        }
        return DEFAULT_GROUP_FIELD;
    }

    public static String fieldToString(MonitorField field) {
        return field.toString();
    }

    static {
        COLOR_STATE.put(DataProviderState.OFF_LINE, COLOR_OFF);
        COLOR_STATE.put(DataProviderState.DISABLED, COLOR_DISABLED);
        COLOR_STATE.put(DataProviderState.NOT_VALIDATED, COLOR_BG);
        COLOR_STATE.put(DataProviderState.NOMINAL, COLOR_GOOD);
        COLOR_STATE.put(DataProviderState.WARNING, COLOR_WARN);
        COLOR_STATE.put(DataProviderState.ALARM, COLOR_ERR);
        fields = new HashMap();
        CORE_STATE_PATTERN = Pattern.compile("[^/]+/state/([^/]+)");
        FORMAT_CONVERSION_PATTERN = Pattern.compile("(?:\\d+\\$)?[^ ]*?\\d*(?:\\.\\d*)?([a-zA-Z]{1,2})(?: .*)?");
        NULL = new MonitorField(null, "", null);
        NAME = new MonitorField("name", "Name", null);
        MonitorField.registerInstance(NAME);
        VALUE = new Value();
        MonitorField.registerInstance(VALUE);
        UNITS = new MonitorField(AgentChannel.Key.UNITS, "Units", new FormattedValue(null, null, null, 2, null, false));
        MonitorField.registerInstance(UNITS);
        LOW_ALARM = new Limit("limitLo", "Low Limit");
        MonitorField.registerInstance(LOW_ALARM);
        LOW_WARN = new Limit("warnLo", "Low Warn");
        MonitorField.registerInstance(LOW_WARN);
        ALERT_LOW = new Alert(AgentChannel.Key.ALERT_LOW);
        MonitorField.registerInstance(ALERT_LOW);
        HIGH_ALARM = new Limit("limitHi", "High Limit");
        MonitorField.registerInstance(HIGH_ALARM);
        HIGH_WARN = new Limit("warnHi", "High Warn");
        MonitorField.registerInstance(HIGH_WARN);
        ALERT_HIGH = new Alert(AgentChannel.Key.ALERT_HIGH);
        MonitorField.registerInstance(ALERT_HIGH);
        DESCR = new MonitorField("description", "Description", new FormattedValue(null, null, null, 2, null, false));
        MonitorField.registerInstance(DESCR);
        AVERAGE_VALUE = new StateColor("value", "Average", MonitorField.VALUE.template, (Set)Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("value", AgentChannel.Key.STATE)))){

            @Override
            public FormattedValue format(List<AgentChannel> channels) {
                if (channels.isEmpty()) {
                    return FormattedValue.EMPTY;
                }
                FormattedValue fv = super.format(channels);
                int n = 0;
                double sum = 0.0;
                for (AgentChannel ch : channels) {
                    if (ch == null) continue;
                    try {
                        Double value = (Double)ch.get(this.key);
                        if (value == null || value.isInfinite() || value.isNaN()) continue;
                        ++n;
                        sum += value.doubleValue();
                    }
                    catch (ClassCastException classCastException) {}
                }
                fv.text = n > 0 ? (fv.format == null ? String.format(this.DEFAULT_FLOAT_FORMAT, sum) : String.format(fv.format, sum /= (double)n, n)) : "";
                return fv;
            }
        };
        MAX_VALUE = new StateColor("value", "Max", MonitorField.VALUE.template, (Set)Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("value", AgentChannel.Key.STATE)))){

            @Override
            public FormattedValue format(List<AgentChannel> channels) {
                if (channels.isEmpty()) {
                    return FormattedValue.EMPTY;
                }
                FormattedValue fv = super.format(channels);
                int n = 0;
                double sum = Double.NEGATIVE_INFINITY;
                for (AgentChannel ch : channels) {
                    if (ch == null) continue;
                    try {
                        Double value = (Double)ch.get(this.key);
                        if (value == null || value.isInfinite() || value.isNaN()) continue;
                        ++n;
                        sum = Math.max(sum, value);
                    }
                    catch (ClassCastException classCastException) {}
                }
                fv.text = n > 0 ? (fv.format == null ? String.format(this.DEFAULT_FLOAT_FORMAT, sum) : String.format(fv.format, sum, n)) : "";
                return fv;
            }
        };
        MIN_VALUE = new StateColor("value", "Min", MonitorField.VALUE.template, (Set)Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("value", AgentChannel.Key.STATE)))){

            @Override
            public FormattedValue format(List<AgentChannel> channels) {
                if (channels.isEmpty()) {
                    return FormattedValue.EMPTY;
                }
                FormattedValue fv = super.format(channels);
                int n = 0;
                double sum = Double.POSITIVE_INFINITY;
                for (AgentChannel ch : channels) {
                    if (ch == null) continue;
                    try {
                        Double value = (Double)ch.get(this.key);
                        if (value == null || value.isInfinite() || value.isNaN()) continue;
                        ++n;
                        sum = Math.min(sum, value);
                    }
                    catch (ClassCastException classCastException) {}
                }
                fv.text = n > 0 ? (fv.format == null ? String.format(this.DEFAULT_FLOAT_FORMAT, sum) : String.format(fv.format, sum, n)) : "";
                return fv;
            }
        };
        MEDIAN_VALUE = new StateColor("value", "Median", MonitorField.VALUE.template, (Set)Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("value", AgentChannel.Key.STATE)))){

            @Override
            public FormattedValue format(List<AgentChannel> channels) {
                if (channels.isEmpty()) {
                    return FormattedValue.EMPTY;
                }
                FormattedValue fv = super.format(channels);
                int n = 0;
                double[] vv = new double[channels.size()];
                for (AgentChannel ch : channels) {
                    if (ch == null) continue;
                    try {
                        Double value = (Double)ch.get(this.key);
                        if (value == null || value.isInfinite() || value.isNaN()) continue;
                        vv[n++] = value;
                    }
                    catch (ClassCastException classCastException) {}
                }
                if (n > 0) {
                    Arrays.sort(vv);
                    double m = n % 2 == 0 ? (vv[n / 2] + vv[n / 2 - 1]) / 2.0 : vv[n / 2];
                    fv.text = fv.format == null ? String.format(this.DEFAULT_FLOAT_FORMAT, m) : String.format(fv.format, m, n);
                } else {
                    fv.text = "";
                }
                return fv;
            }
        };
        HOST = new MonitorField("org.lsst.ccs.agent.hostname", "Host", new FormattedValue(null, null, null, 0, null, false));
        MonitorField.registerInstance(HOST);
        DEFAULT_GROUP_FIELD = AVERAGE_VALUE;
        GROUP_FIELDS = new MonitorField[]{AVERAGE_VALUE, MAX_VALUE, MIN_VALUE, MEDIAN_VALUE};
    }

    public static class Average
    extends MonitorField {
        private final boolean checkState;

        public Average(String key, String title, FormattedValue template, Set<String> keys) {
            super(key, title, template, keys);
            this.checkState = keys.contains(AgentChannel.Key.STATE);
        }

        @Override
        public FormattedValue format(List<AgentChannel> channels) {
            if (channels.isEmpty()) {
                return FormattedValue.EMPTY;
            }
            int n = 0;
            double sum = 0.0;
            int highestState = -1;
            for (AgentChannel ch : channels) {
                if (ch == null) continue;
                if (this.checkState) {
                    DataProviderState state = (DataProviderState)ch.get(AgentChannel.Key.STATE);
                    int ordinal = state == null ? -1 : state.ordinal();
                    highestState = Math.max(highestState, ordinal);
                    if (ordinal < DataProviderState.NOMINAL.ordinal()) continue;
                }
                try {
                    Double value = (Double)ch.get(this.key);
                    if (value == null || value.isInfinite() || value.isNaN()) continue;
                    ++n;
                    sum += value.doubleValue();
                }
                catch (ClassCastException classCastException) {}
            }
            if (n > 0) {
                sum /= (double)n;
            } else {
                return FormattedValue.NA;
            }
            FormattedValue fv = new FormattedValue(this.template);
            if (fv.bgColor == null && highestState >= 0) {
                fv.bgColor = (Color)COLOR_STATE.get(DataProviderState.values()[highestState]);
            }
            fv.text = fv.format == null ? String.format(this.DEFAULT_FLOAT_FORMAT, sum) : String.format(fv.format, sum, n);
            return fv;
        }
    }

    private static class StateColor
    extends MonitorField {
        private final boolean checkState;

        public StateColor(String key, String title, FormattedValue template, Set<String> keys) {
            super(key, title, template, keys);
            this.checkState = keys.contains(AgentChannel.Key.STATE);
        }

        @Override
        public FormattedValue format(List<AgentChannel> channels) {
            int highestState = -1;
            for (AgentChannel ch : channels) {
                if (ch == null || !this.checkState) continue;
                DataProviderState state = (DataProviderState)ch.get(AgentChannel.Key.STATE);
                int ordinal = state == null ? -1 : state.ordinal();
                highestState = Math.max(highestState, ordinal);
            }
            FormattedValue fv = new FormattedValue(this.template);
            if (fv.bgColor == null && highestState >= 0) {
                fv.bgColor = (Color)COLOR_STATE.get(DataProviderState.values()[highestState]);
            }
            return fv;
        }
    }

    private static class Limit
    extends MonitorField {
        Limit(String key, String title) {
            super(key, title, null);
        }

        @Override
        public FormattedValue format(AgentChannel channel) {
            if (channel == null) {
                return FormattedValue.NA;
            }
            FormattedValue fv = new FormattedValue();
            fv.horizontalAlignment = 4;
            Object f = channel.get(AgentChannel.Key.FORMAT);
            fv.format = f instanceof String ? (String)f : this.DEFAULT_FLOAT_FORMAT;
            fv = this.defaultFormat(channel, fv);
            return fv;
        }
    }

    private static class Alert
    extends MonitorField {
        Alert(String key) {
            super(key, "Al.", null);
        }

        @Override
        public FormattedValue format(AgentChannel channel) {
            String text;
            String alertName;
            Object value = channel.get(this.key);
            if (value instanceof String && !((String)value).trim().isEmpty()) {
                alertName = (String)value;
                text = "  \u2713  ";
            } else {
                alertName = "No alert";
                text = " ";
            }
            return new FormattedValue(text, COLOR_FG, COLOR_BG, 0, alertName, false);
        }
    }

    private static class Value
    extends MonitorField {
        Value() {
            super("value", "Value", new FormattedValue(null, null, null, 4, null, null), Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("value", AgentChannel.Key.STATE))));
        }

        @Override
        public FormattedValue format(AgentChannel channel) {
            String path;
            if (channel == null) {
                return FormattedValue.NA;
            }
            FormattedValue fv = new FormattedValue(this.template);
            if (fv.format == null) {
                fv.format = (String)channel.get(AgentChannel.Key.FORMAT);
            }
            fv = this.defaultFormat(channel, fv);
            if (fv.bgColor == null && fv.value instanceof String && (path = channel.getPath()).contains("/state/")) {
                String value = (String)fv.value;
                Matcher m = CORE_STATE_PATTERN.matcher(path);
                if (m.matches()) {
                    block7 : switch (m.group(1)) {
                        case "AlertState": {
                            switch (value) {
                                case "NOMINAL": {
                                    fv.bgColor = COLOR_GOOD;
                                    break;
                                }
                                case "WARNING": {
                                    fv.bgColor = COLOR_WARN;
                                    break;
                                }
                                case "ALARM": {
                                    fv.bgColor = COLOR_ERR;
                                }
                            }
                            break;
                        }
                        case "CommandState": {
                            switch (value) {
                                case "READY": {
                                    fv.bgColor = COLOR_GOOD;
                                    break;
                                }
                                case "ACTIVE": {
                                    fv.bgColor = COLOR_WARN;
                                }
                            }
                            break;
                        }
                        case "ConfigurationState": {
                            switch (value) {
                                case "CONFIGURED": {
                                    fv.bgColor = COLOR_GOOD;
                                    break block7;
                                }
                            }
                            fv.bgColor = COLOR_WARN;
                            break;
                        }
                        case "OperationalState": {
                            switch (value) {
                                case "NORMAL": {
                                    fv.bgColor = COLOR_GOOD;
                                    break;
                                }
                                case "ENGINEERING_OK": {
                                    fv.bgColor = COLOR_WARN;
                                    break;
                                }
                                case "ENGINEERING_FAULT": {
                                    fv.bgColor = COLOR_ERR;
                                }
                            }
                            break;
                        }
                        case "PhaseState": {
                            switch (value) {
                                case "OPERATIONAL": {
                                    fv.bgColor = COLOR_GOOD;
                                    break block7;
                                }
                                case "INITIALIZING": 
                                case "CLOSING": {
                                    fv.bgColor = COLOR_WARN;
                                    break block7;
                                }
                                case "OFF_LINE": {
                                    fv.bgColor = COLOR_ERR;
                                }
                            }
                        }
                    }
                }
            }
            return fv;
        }
    }
}

